#!/bin/sh

clear

SPDBVVERSION="3.7"
SPDBVNEEDOSbis="IRIX"
SPDBVNEEDOS="Linux"

SPDBVUSERDIR="$HOME"
SPDBVSHAREDIR="/usr/share"
SPDBVDIR="SPDBV"
SPDBVSTUFF="_stuff_"
SPDBVDEST=""
SPDBVOSVERSION=`uname -r`
SPDBVOS=`uname -s`
if [ $SPDBVOS = IRIX64 ]; then
  SPDBVOS=IRIX
fi

abort () {
        echo "Installation aborted."
        exit
}

# install the shared files under the choice SPDBVDEST
makesharedinst () {
    echo "Will install the shared files in $SPDBVDEST."
    if [  -d $SPDBVDEST/$SPDBVDIR ]; then
        echo "Shared files are already installed on this system."
        echo "Delete old files and reinstall (Y/N)?"
        read INP
        if [ $INP = "Y" -o $INP = "y" ]; then
            echo " "
            echo "will reinstall"
	    if [ -w $SPDBVDEST/$SPDBVDIR ]; then
		rm -r $SPDBVDEST/$SPDBVDIR
	    else
	        echo "Could not delete shared files."
		abort
	    fi
        else
            abort
        fi
    fi
    mkdir $SPDBVDEST/$SPDBVDIR #2> /dev/null
    if [ ! -d $SPDBVDEST/$SPDBVDIR ]; then
	echo "Could not write to shared files folder $SPDBVDEST"
	abort
    fi

    OLDDIR=`pwd`
    cd $SPDBVDEST
    gunzip -c $OLDDIR/shared.tar.gz | tar xf - 2> /dev/null
    #copy stuff la bas
    cd $OLDDIR
    if [ ! -d $SPDBVDEST/$SPDBVDIR ]; then
	echo "Could not write to shared files folder $SPDBVDEST"
	abort
    fi
    echo "#!/bin/sh" > $SPDBVDEST/$SPDBVDIR/bin/spdbv
    echo "SPDBV_BASE=$SPDBVDEST/$SPDBVDIR" >> $SPDBVDEST/$SPDBVDIR/bin/spdbv
    cat ./SPDBV/bin/spdbv-orig.sh >> $SPDBVDEST/$SPDBVDIR/bin/spdbv
    chmod ugo+rx $SPDBVDEST/$SPDBVDIR/bin/spdbv

    #try to make link from /usr/bin/spdbv to ./spdbv
    if [ ! -w /usr/bin/ ]; then
       echo " "
       echo "Can't make a link from /usr/bin/spdbv to $SPDBVDEST/$SPDBVDIR/bin/spdbv"
    else
       ln -sf $SPDBVDEST/$SPDBVDIR/bin/spdbv /usr/bin/spdbv
    fi
}

#
# the MENU is the programm
#	
mainmenu () {
   clear
   echo " "
   echo " SPDBV - Swiss PDB Viewer" 
   echo " Installation script for Release $SPDBVVERSION ($SPDBVNEEDOS)"
   echo " " 
   echo " " 
   echo " Please follow the instructions below."
   echo " "
   echo "Where do you want me to install the files:"
   echo "globally in /usr/share/SPDBV  ->  G"
   echo "or just locally in ~/SPDBV    ->  L"
   echo "something different           ->  O"
   echo "(G/L/O)?"
   read DEST

   SPDBVDEST=""
   if [ $DEST = "G" -o $DEST = "g" ]; then
       SPDBVDEST=$SPDBVSHAREDIR
   elif [ $DEST = "L" -o $DEST = "l" ]; then
       SPDBVDEST=$SPDBVUSERDIR
   elif [ $DEST = "O" -o $DEST = "o" ]; then
       echo "enter target Path where to install directory SPDBV:"
       read SPDBVDEST
   fi

   if [ -z $SPDBVDEST ]; then
       echo ""
       echo "$SPDBVDEST is not a valid answer. 1"
       echo ""
       echo "continue .. hit any key"
       read DEST
       mainmenu
   fi
   if [ ! '(' -d $SPDBVDEST ')' ]; then
       echo ""
       echo "$SPDBVDEST is not a valid answer. 2"
       echo ""
       echo "continue .. hit any key"
       read DEST
       mainmenu
   fi

   makesharedinst

#   clear

   echo " "
   echo " SPDBV - Swiss PDB Viewer" 
   echo " Installation script for Release $SPDBVVERSION ($SPDBVNEEDOS)"
   echo " "
   echo "Installation completed."
   echo "Start your copy of SPDBV with the script $SPDBVDEST/$SPDBVDIR/bin/spdbv"
   echo ""
   echo "ENJOY SPDBV!"
   exit
}

# test for the right os
if [ $SPDBVOS != $SPDBVNEEDOS ]; then
  if [ $SPDBVOS != $SPDBVNEEDOSbis ]; then 
    echo "SPDBV $SPDBVVERSION ($SPDBVNEEDOS) is intended to run on hardware under $SPDBVNEEDOS."
    abort
    exit
  fi
fi

# start up the mainmenu
mainmenu 
# should never get here
exit

