/* rmm.c - remove a message */
#ifndef	lint
static char ident[] = "@(#)$Id: rmm.c,v 1.1.1.1 2005/04/18 14:46:07 kono Exp $";
#endif	/* lint */

#include "../h/mh.h"
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef LOCALE
#include	<locale.h>
#endif

/*  */

static struct swit switches[] = {
#define	HELPSW	0
    "help", 4,

    NULL, 0
};

/*  */

#ifdef MH_PLUS
struct msgs	*opntrashf ();
struct msgs	*trash ();
#endif /* MH_PLUS */

/* ARGSUSED */

main (argc, argv)
int     argc;
char  **argv;
{
    int     msgp = 0,
            msgnum,
#ifdef MH_PLUS
            vecp,
            rmp;
#else /* MH_PLUS */
            vecp;
#endif /* MH_PLUS */
    char   *cp,
           *dp,
           *maildir,
           *folder = NULL,
#ifdef MH_PLUS
           *tfold = NULL,
#endif /* MH_PLUS */
            buf[100],
          **ap,
          **argp,
          **vec,
           *arguments[MAXARGS],
           *msgs[MAXARGS];
#ifdef MH_PLUS
    struct msgs *mp,
                *tmp;
#else /* MH_PLUS */
    struct msgs *mp;
#endif /* MH_PLUS */

#ifdef LOCALE
	setlocale(LC_ALL, "");
#endif
#ifdef JAPAN
	ml_init();
#endif /* JAPAN */
    invo_name = r1bindex (argv[0], '/');
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    (void) copyip (argv + 1, ap);
    argp = arguments;

/*  */

    while (cp = *argp++) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULLCP, "-%s unknown\n", cp);
		case HELPSW: 
		    (void) sprintf (buf, "%s [+folder] [msgs] [switches]",
			    invo_name);
		    help (buf, switches);
		    done (1);
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULLCP, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }

/*  */

    if (!m_find ("path"))
	free (path ("./", TFOLDER));
    if (!msgp)
	msgs[msgp++] = "cur";
    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");
    if (!(mp = m_gmsg (folder)))
	adios (NULLCP, "unable to read folder %s", folder);
    if (mp -> hghmsg == 0)
	adios (NULLCP, "no messages in %s", folder);

#ifdef MH_PLUS
    if (!rmmproc && (tfold = m_find ("Trash-Folder"))) {
	tmp = opntrashf (tfold, cp = getcpy (maildir), &rmp);
	free (cp);
    }
#endif /* MH_PLUS */

    for (msgnum = 0; msgnum < msgp; msgnum++)
	if (!m_convert (mp, msgs[msgnum]))
	    done (1);
    m_setseq (mp);

    for (msgnum = mp -> lowsel; msgnum <= mp -> hghsel; msgnum++)
	if (mp -> msgstats[msgnum] & SELECTED) {
#ifdef	notdef
	    mp -> msgstats[msgnum] |= DELETED;
#endif	/* notdef */
	    mp -> msgstats[msgnum] &= ~EXISTS;
	}
    mp -> msgflags |= SEQMOD;

    m_replace (pfolder, folder);
    m_sync (mp);
    m_update ();

    if (rmmproc) {
	if (mp -> numsel > MAXARGS - 2)
	    adios (NULLCP, "more than %d messages for %s exec", MAXARGS - 2,
		    rmmproc);
	vec = (char **) calloc ((unsigned) (mp -> numsel + 2), sizeof *vec);
	if (vec == NULL)
	    adios (NULLCP, "unable to allocate exec vector");
	vecp = 1;
	for (msgnum = mp -> lowsel; msgnum <= mp -> hghsel; msgnum++)
	    if (mp -> msgstats[msgnum] & SELECTED)
		vec[vecp++] = getcpy (m_name (msgnum));
	vec[vecp] = NULL;

	(void) fflush (stdout);
	vec[0] = r1bindex (rmmproc, '/');
	execvp (rmmproc, vec);
	adios (rmmproc, "unable to exec");
    }

    for (msgnum = mp -> lowsel; msgnum <= mp -> hghsel; msgnum++)
	if (mp -> msgstats[msgnum] & SELECTED) {
#ifdef MH_PLUS
	    if (tfold) {
		tmp = trash (msgnum, tmp, rmp);
		continue;
	    }
#endif /* MH_PLUS */
	    (void) strcpy (buf, m_backup (dp = m_name (msgnum)));
	    if (rename (dp, buf) == NOTOK)
		admonish (buf, "unable to rename %s to", dp);
	}

    done (0);
}

#ifdef MH_PLUS
struct msgs *
opntrashf (tfold, cwd, rmp)
char    *tfold,
        *cwd;
int     *rmp;
{
    int     len;
    char   *tf,
           *cp,
           *trashdir;
    struct stat  st;
    struct msgs *tmp;

    tf = path (*tfold == '+' || *tfold == '@' ? tfold + 1 : tfold,
	       *tfold != '@' ? TFOLDER : TSUBCWF);
    if (*tfold == '@' && *(tfold + 1) != '/') {
	cp = tfold + 1;
	while (*cp) {
	    if (strncmp (cp, "./", 2) == 0)
		cp += 2;
	    else if (strncmp (cp, "../", 3) == 0)
		cp += 3;
	    else
		break;
	}
	len = strlen(cp);
	if (strncmp(cwd + strlen(cwd) - len, cp, len) == 0) {
	    trashdir = ".";
	    tf = path ("./", TSUBCWF);
	} else
	    trashdir = m_maildir (tf);
    } else
	trashdir = m_maildir (tf);
    if (strcmp(cwd, trashdir) == 0)
	trashdir = ".";
    *rmp = strcmp(trashdir, ".") ? 0 : 1;

    if (stat (trashdir, &st) == NOTOK) {
	if (errno != ENOENT)
	    adios (trashdir, "error on folder");
	cp = concat ("Create folder \"", trashdir, "\"? ", NULLCP);
	if (!getanswer (cp))
	    done (1);
	free (cp);
	if (!makedir (trashdir))
	    adios (NULLCP, "unable to create folder %s", trashdir);
    }
    if (chdir (trashdir) == NOTOK)
	adios (trashdir, "unable to change directory to");
    if (!(tmp = m_gmsg (tf)))
	adios (NULLCP, "unable to read folder %s", tfold);
    tmp -> curmsg = 0;
    chdir (cwd);
    return tmp;
}

struct msgs *
trash (msgnum, tmp, rmp)
struct msgs *tmp;
int     msgnum,
        rmp;
{ 
    int     newnum;
    char   *msg,
            newmsg[BUFSIZ];

    if (rmp) {
	msg = m_name (msgnum);
	if (unlink (msg) == NOTOK)
	    admonish (msg, "unable to unlink");
	return tmp;
    }

    if (tmp -> hghmsg >= tmp -> hghoff)
	if (!(tmp = m_remsg (tmp, 0, tmp -> hghoff + MAXFOLDER)))
	    adios (NULLCP, "unable to allocate folder storage");

    newnum = ++tmp -> hghmsg;
    tmp -> nummsg++;
    tmp -> msgstats[newnum] |= EXISTS | SELECTED;
    if (tmp -> lowmsg == 0)
	tmp -> lowmsg = newnum;
    if (tmp -> lowsel == 0 || newnum < tmp -> lowsel)
	tmp -> lowsel = newnum;
    if (newnum > tmp -> hghsel)
	tmp -> hghsel = newnum;

    (void) sprintf (newmsg, "%s/%s", tmp -> foldpath, m_name (newnum));
    msg = m_name (msgnum);
    if (rename (msg, newmsg) == NOTOK) {
	int in, out;
	struct stat st;
	if (stat (newmsg, &st) != NOTOK) {
	    admonish (newmsg, "unable to rename %s to", msg);
	    return tmp;
	}
	if ((in = open(msg, 0)) == NOTOK) {
	    admonish (msg, "unable to open message");
	    return tmp;
	}
	(void) fstat (in, &st);
	if ((out = creat (newmsg, (int) st.st_mode & 0777)) == NOTOK) {
	    admonish (newmsg, "unable to create");
	    (void) close (in);
	    return tmp;
	}
	cpydata (in, out, msg, newmsg);
	(void) close (in);
	(void) close (out);
	if (unlink (msg) == NOTOK)
	    admonish (msg, "unable to unlink");
    }
    return tmp;
}
#endif /* MH_PLUS */
