/* advertise.c - the heart of adios */
#ifndef	lint
static char ident[] = "@(#)$Id: advertise.c,v 1.2 2006/12/05 18:18:03 kono Exp $";
#endif	/* lint */

#include "../h/mh.h"
#include <stdio.h>
#if defined(BSD42) || defined(SVR4)
#include <sys/types.h>
#include <sys/uio.h>
#endif	/* BSD42 || SVR4 */

/* For 4.2BSD systems, use writev() for slightly better performance.  Why?
   Well, there are a couple of reasons.  Primarily, it gives a smoother
   output...  More importantly though, it's a sexy syscall()...
 */

#include <errno.h>

#if !defined(BSD44) && !defined(__GNU_LIBRARY__)	/* in <stdio.h> */
extern int  sys_nerr;
extern char *sys_errlist[];
#endif
#ifdef __NetBSD__ /* XXX */
#include <errno.h>
#endif

/*  */

/* VARARGS3 */

void advertise (what, tail, fmt, a, b, c, d, e, f, g)
char   *what,
       *tail,
       *fmt,
       *a,
       *b,
       *c,
       *d,
       *e,
       *f,
       *g;
{
    int	    eindex = errno;
#ifdef JAPAN
    char    buffer[BUFSIZ * 2];
#else /* JAPAN */
#if defined(BSD42) || defined(SVR4)
    char    buffer[BUFSIZ * 2],
            err[BUFSIZ];
    struct iovec    iob[20];
    register struct iovec  *iov = iob;
#endif	/* BSD42 || SVR4 */
#endif /* JAPAN */

    (void) fflush (stdout);

#ifdef JAPAN
    if (invo_name && *invo_name) {
	(void)sprintf(buffer, "%s: ", invo_name);
	ml_fputs(buffer, stderr);
    }
    (void)sprintf(buffer, fmt, a, b, c, d, e, f, g);
    ml_fputs(buffer, stderr);
    if (what) {
	if (*what) {
	    (void)sprintf(buffer, " %s: ", what);
	    ml_fputs(buffer, stderr);
	}
	if (eindex > 0 && eindex < sys_nerr) {
	    (void)sprintf(buffer, "%s", sys_errlist[eindex]);
	    ml_fputs(buffer, stderr);
	} else {
	    (void)sprintf(buffer, "Error %d", eindex);
	    ml_fputs(buffer, stderr);
	}
    }
    if (tail) {
	(void)sprintf(buffer, ", %s", tail);
	ml_fputs(buffer, stderr);
    }
    ml_fputs("\n", stderr);
#else /* JAPAN */
#if !defined(BSD42) && !defined(SVR4)
    if (invo_name && *invo_name)
	fprintf (stderr, "%s: ", invo_name);
    fprintf (stderr, fmt, a, b, c, d, e, f, g);
    if (what) {
	if (*what)
	    fprintf (stderr, " %s: ", what);
	if (eindex > 0 && eindex < sys_nerr)
	    fprintf (stderr, "%s", sys_errlist[eindex]);
	else
	    fprintf (stderr, "Error %d", eindex);
    }
    if (tail)
	fprintf (stderr, ", %s", tail);
    (void) fputc ('\n', stderr);
#else	/* BSD42 || SVR4 */
    (void) fflush (stderr);

    if (invo_name && *invo_name) {
	iov -> iov_len = strlen (iov -> iov_base = invo_name);
	iov++;
	iov -> iov_len = strlen (iov -> iov_base = ": ");
	iov++;
    }
    
    (void) sprintf (buffer, fmt, a, b, c, d, e, f, g);
    iov -> iov_len = strlen (iov -> iov_base = buffer);
    iov++;
    if (what) {
	if (*what) {
	    iov -> iov_len = strlen (iov -> iov_base = " ");
	    iov++;
	    iov -> iov_len = strlen (iov -> iov_base = what);
	    iov++;
	    iov -> iov_len = strlen (iov -> iov_base = ": ");
	    iov++;
	}
	if (eindex > 0 && eindex < sys_nerr)
	    iov -> iov_len
		= strlen (iov -> iov_base = (char *) sys_errlist[eindex]);
	else {
	    (void) sprintf (err, "Error %d", eindex);
	    iov -> iov_len = strlen (iov -> iov_base = err);
	}
	iov++;
    }
    if (tail && *tail) {
	iov -> iov_len = strlen (iov -> iov_base = ", ");
	iov++;
	iov -> iov_len = strlen (iov -> iov_base = tail);
	iov++;
    }
    iov -> iov_len = strlen (iov -> iov_base = "\n");
    iov++;
    (void) writev (fileno (stderr), iob, iov - iob);
#endif	/* BSD42 || SVR4 */
#endif /* JAPAN */
}
