case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting man/ungeek.$manext (with variable substitutions)"
$rm -f ungeek.$manext
$spitshell >ungeek.$manext <<!GROK!THIS!
.TH UNGEEK $manext "Version $VERSION PL$PATCHLEVEL"
''' @(#) Manual page for ungeek -- (c) petew March 1996
'''
''' $Log:	ungeek.SH,v $
''' Revision 3.1.1.2  96/03/21  20:16:46  petew
''' patch1: Baseline revision for netwide release
''' 
''' Revision 3.1.1.1  96/03/21  20:14:01  petew
''' Baseline revision for netwide release
''' 
''' Revision 3.1  96/03/21  18:59:56  petew
''' patch1: Baseline for ungeek 3.1 dist release.
''' 
''' Revision 3.1.1.1  96/03/21  18:23:51  petew
''' patch1: Distribution release
'''
.SH NAME
ungeek \- interpreter for the \fIGeek Code 3.x\fR
.SH SYNOPSIS
ungeek [\-h] [\-m] [\-n \fInumber\fR] [\-t \fIcode\fR] [\-r] [\-x]
[\fIfiles\fR]
.SH DESCRIPTION
.I ungeek
is a tool for extracting and interpreting the \fIGeek Code\fR (Version 3.x).
.PP
\fIungeek\fR can be used to merely extract the geek code from a file,
to test \fIGeek Code\fR fragments when constructing one's own geek code, or
it can be used to extract and interpret a geek code from a file, pipe or
stdin redirection.
.SH OPTIONS
\fIungeek\fR options cannot be bundled, even for those requiring no arguments.
That is, one cannot enter something like:
.sp
imageek% ungeek \-rmx myfilename
.sp
All unrecognized command line arguments are assumed to be filenames and are
treated as such.  If no filenames are given on the command line, input is
assumed to be coming from standard input, so that \fIungeek\fR can be used
in a pipeline or redirect.
.sp
.PD 0
.TP 10
Valid options are:
.sp
.TP
.B \-h
Help.  Probably the most important.  And so easy to remember...
.sp
.TP
.B \-m
Mail.  Input is assumed to be an email message.  \fIungeek\fR will attempt
to extract the From: headers of the file and print to standard output who
the message is from, followed by the geek code.  If there are several
From: lines in the input stream, they will be printed out before the next
chunk of geek code encountered.  If no "From" lines are found, nothing will
be printed out.  Sorry, no PGP-type authentication is built into this, so
some discretion is advised ;-).
.sp
.TP
\fB\-n \fI num\fR
Number of matches to search for.  Normally, \fIungeek\fR will look for at
least 5 consecutive valid \fIGeek Code\fR tokens before it decides it has
"found" the code.  With this option, at least \fInum\fR matches must be
found.  If this option is used without the -r switch (see below),
\fIungeek\fR first looks for a valid "geek type" code and then looks for
(\fInum\fR \- 1) other valid code tokens before assuming it has found a
match.
.sp
.TP
.B \-r
Relax restrictions on matching tokens.  Using this option will allow one to
pull out anything that looks like it might be a valid \fIGeek Code\fR
fragment from stdin.  Note that normally, \fIungeek\fR looks first for a
valid "geek type" code before testing other geek code tokens.  Using this
flag removes this restriction.  This can be used in conjunction with the -n
flag to match at least num tokens before printing anything out.
.sp
.TP
\fB\-t \fI code\fR
Test the code fragment \fIcode\fR, where \fIcode\fR can be any number of
geek code tokens.  Normally the code fragment would be enclosed in quotes
with shell metacharacters backslashed to prevent interpretation by the
shell.
.sp
.TP
.B \-x
Extract the code only from stdin.  Without this option, \fIungeek\fR will
provide a code interpretation, followed by the code itself.  With this
option, only the geek code itself is printed to stdout.
.sp
.TP
.B filename 
Any other options passed to \fIungeek\fR are assumed to be filenames.
.PD
.SH ENVIRONMENT
No environment variables are used.
.PP
.SH FILES
None.
.PP
.SH AUTHOR
Pete Williams <petew@lexis-nexis.com>
.PP
.SH SEE ALSO
The \fIGeek Code 3.x\fR, written and developed by Robert Hayden 
<hayden@krypton.mankato.msus.edu>.
.PP
.SH DIAGNOSTICS
Requires Perl4.036 or later.
.PP
.SH BUGS
Probably.  Please notify the author of any you find.
!GROK!THIS!
chmod 444 ungeek.$manext
