case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting man/geekcode.$manext (with variable substitutions)"
$rm -f geekcode.$manext
$spitshell >geekcode.$manext <<!GROK!THIS!
.TH GEEKCODE $manext "Version $VERSION PL$PATCHLEVEL"
''' @(#) Manual page for The Geek Code (c) Robert Hayden 
'''
''' $Log:	geekcode.SH,v $
''' Revision 3.1.1.2  96/03/21  20:16:45  petew
''' patch1: Baseline revision for netwide release
''' 
''' Revision 3.1.1.1  96/03/21  20:13:59  petew
''' Baseline revision for netwide release
''' 
''' Revision 3.1  96/03/21  18:59:53  petew
''' patch1: Baseline for ungeek 3.1 dist release.
''' 
''' Revision 3.1.1.1  96/03/21  18:23:51  petew
''' patch1: Distribution release
''' 
''' Revision 1.1  1996/02/15 17:54:25  pete
''' Initial revision
'''
''' Revision 1.5.1.1  1996/01/31 01:45:29  pete
''' patch1: Robert Hayden's Geek Code in manpage format
'''
''' 
.SH NAME
\fBGeek Code\fR \- The Code of the Geeks, Version 3.1
.SH DESCRIPTION
So you think you are a geek, eh?  The first step is to admit to yourself
your geekiness.  No matter what anyone says, geeks are people too; geeks
have rights.  So take a deep breath and announce to the world that you are
a geek.  Your courage will give you strength that will last you forever.
.PP
How to tell the world you are a geek, you ask?  Use the universal Geek
code!  Using this special code will allow you to let other un-closeted
geeks know who you are in a simple, codified statement. 
.PP
The single best way to announce your geekhood is to add your geek code to
your signature file or plan and announce it far and wide.  But be careful,
you may give other geeks the courage to come out of the closet.  You might
want to hang on to your copy of the code in order to help them along. 
.SH "A NOTE OR TWO FROM THE AUTHOR"
Well, here it is, finally, version 3.x of the World-Famous \fIGeek Code\fR. 
Yes, it's taken me much longer to write the new version than it should
have.  Yes, the old version was hopelessly out of date.  I apologize.  A
combination of too much schooling followed by college graduation delayed
it.  In addition, there were almost 2,000 suggestions and comments on
version 2.1 to wade through for consideration in this version.  However,
I'm a grad student now (Education Technology, Mankato State University),
so I have a lot of time on my hands (yeah, right!). 
.PP
It is my hope that this new version will be much superior to version 2.x. 
One of the main problems with 2.x was not that it was too long (well, it is
too long, but that's irrelevant), but much of its length was attributed to
non-geek categories (such as \*(L'barney').  One of the goals of 3.x is to
eliminate many of the non-geeky and unimportant categories in order to make
room for geeky traits.  \*(L"More geek, less bullshit\*(R" is a good motto. 
In addition, many of the categories (such as politics) were very poorly
developed.  These categories have been revamped and expanded to make them
more fully cover all the requisite areas. 
.PP
Finally, despite my opinions to the contrary, I've left some of the
\*(L"appearance\*(R" sections in.  I'd like to think of looks as being not
a very geeky trait, but it seems that many of the users of the code use it
as a litmus test for dating or something.  Thus, a geek code has become a
replacement for the classic \*(L"what do you look like\*(R" that once
permeated the net.  I've eliminated most of the categories, but left the
most important ones in.  Hey, anything for my fellow geeks... 
.PP
In other news, the \fIGeek Code\fR is starting to go mainstream.  It appeared
with commentary in the March \*(L'95 issue of Boardwatch magazine as well as
the August 1995 issue of Fast Forward, a supplement to The Washington
Post.  I've also received permission requests from people that want to
translate the code into other languages; so far Japanese, Russian,
Spanish, French and ADA (ewww!).  It's my hope that perhaps this next year
can bring a little more popular media exposure and a true world presence. 
If you want to write something about the \fIGeek Code\fR, or do a translation,
or anything else, please read the copyright notice at the end.  It's
fairly open, but you don't want to get in trouble, do you?  If you do
write an article or something about the \fIGeek Code\fR, I would like to have a
copy if it for my own records. 
.SH "INSTRUCTIONS"
The geek code consists of several categories.  Each category is labeled
with a letter and some qualifiers.  Go through each category and determine
which set of qualifiers best describes you in that category.  By stringing
all of these \*(L'codes\*(R' together, you are able to construct your
overall geek code.  It is this single line of code that will inform other
geeks the world over of what a great geek you actually are.
.PP
Some of the qualifiers will very probably not match with you exactly.  It
is impossible to cover all possibilities in each category.  Simply choose
that qualifier that MOST CLOSELY matches you.  Also, some activities
described in a specific qualifier you may not engage in, while you do
engage in others.  Each description of each qualifier describes the wide
range of activities that apply, so as long as you match with one, you can
probably use that qualifier. 
.PP
Also, pay particular attention to case-sensitivity, there can be a big
difference between a \*(L'w\*(R' and a \*(L'W\*(R'.
.PP
After you have determined each of your qualifiers, you need to then
construct your GEEK CODE BLOCK.  Instructions are provided on how to do
this towards the end of this file. 
.SH "VARIABLES"
Geeks can seldom be strictly quantified.  To facilitate the fact that
within any one category the geek may not be able to determine a
specific rating, variables have been designed to allow this range to
be included.
.sp
.PD 0
.TP 10
.I  @
for this variable, said trait is not very rigid, may change with
time or with individual interaction.  For example, Geeks who
happen to very much enjoy Star Trek: The Next Generation, but
dislike the old 60's series might list themselves as t++@.
.TP
.I ()
for indicating "cross-overs" or ranges.  Geeks who go from C+ to
C--- depending on the situation (i.e.  mostly "C+") could use
C+(---).  @ is different from () in that () has finite limits
within the category, while @ ranges all over.
.TP
.I >
for 'wannabe' ratings.  Indicating that while the geek is
currently at one rating, they are striving to reach another.  For
example, C++>$ indicating a geek that is currently computer savvy,
but wants to someday make money at it.
.TP
.I $
Indicates that this particular category is done for a living.  For
example, UL+++$ indicates that the person utilizes Unix and gets
paid for it.  Quite a lucky geek, for sure.
.TP
.I ?
Unless stated otherwise within the specific category, the ?  is
placed after the category identifier and indicates that the geek
has no knowledge about that specific category.  For example, a
person that has never even heard of Babylon 5, would list their
Babylon 5 category as 5?
.TP
.I !
Placed BEFORE the category.  Unless stated otherwise, indicates
that the person refuses to participate in this category.  This is
unlike the ?  variable as the ?  indicates lack of knowledge,
while the !  indicates stubborn refusal to participate.  For
example, !E would be a person that just plain refuses to have
anything to do with Emacs, while E?  would be a person that
doesn't even know what Emacs is.
.PD
.SH "TYPES OF GEEKS"
Geeks come in many flavors.  The flavors relate to the vocation (or, if a
student, what they are training in) of the particular geek.  To start a
code, a geek must declare himself or herself to be a geek.  To do this, we
start the code with a "G" to denote "GEEK", followed by one
or two letters to denote the geek's occupation or field of study. 
Multi-talented geeks with more than one vocational training should denote
their myriad of talents with a slash between each vocation (example:
GCS/MU/TW). 
.sp
.PD 0
.TP 10
GB
Geek of Business
.TP
GC
Geek of Classics
.TP
GCA
Geek of Commercial Arts
.TP
GCM
Geek of Computer Management
.TP
GCS
Geek of Computer Science
.TP
GCC
Geek of Communications
.TP
GE
Geek of Engineering
.TP
GED
Geek of Education
.TP
GFA
Geek of Fine Arts
.TP
GG
Geek of Government
.TP
GH
Geek of Humanities
.TP
GIT
Geek of Information Technology
.TP
GJ
Geek of Jurisprudence (Law)
.TP
GLS
Geek of Library Science
.TP
GL
Geek of Literature
.TP
GMC
Geek of Mass Communications
.TP
GM
Geek of Math
.TP
GMD
Geek of Medicine
.TP
GMU
Geek of Music
.TP
GPA
Geek of Performing Arts
.TP
GP
Geek of Philosophy
.TP
GS
Geek of Science (Physics, Chemistry, Biology, etc.)
.TP
GSS
Geek of Social Science (Psychology, Sociology, etc.)
.TP
GTW
Geek of Technical Writing
.TP
GO
Geek of Other.  Some types of geeks deviate from the normal geek
activities.  This is encouraged as true geeks come from all walks of life.
.TP
GU
Geek of 'Undecided'.  This is a popular vocation with incoming freshmen.
.TP
G!
Geek of no qualifications.  A rather miserable existence, you would think.
.TP
GAT
Geek of All Trades.  For those geeks that can do anything and everything. 
GAT usually precludes the use of other vocational descriptors.
.PD
.SH "SECTION I -- APPEARANCE"
They say you never get a second chance to make a first impression.  That
seems to be ample justification to invent a time machine; just to play
with the minds of the people that make up these silly sayings.  
Nevertheless, until we completely understand temporal mechanics and can 
get both a DeLorean and a Flux Capacitor in the same place at the same 
time at 88 miles an hour, we need to understand that how we look is a 
mark that will effect us for the rest of our lives, or at least until we
change clothes.  
.PP
The Geek, of course, doesn't believe any of that crap.  How we look has
little to do with what we are inside, and who we are as people.  Yet,
people still want to know what we look like.  Thus, this section allows
you to list out all the relevant traits about what you look like on a
normal geeky day. 
.Sh "\s-1DRESS\s0 "
It is said that "clothes make the man".  Well, I understood that I
was made by a mommy and a daddy (and there's even a category to describe
the process below!).  Maybe the people who made up that saying aren't being
quite that literal... 
.sp
.PD 0
.TP 10
d++
I tend to wear conservative dress such as a business suit
or worse, a tie.
.TP
d+
Good leisure-wear.  Slacks, button-shirt, etc.  No jeans, tennis shoes, or
t-shirts.
.TP
d
I dress a lot like those found in catalog ads.  Bland, boring, without life
or meaning.
.TP
d-
I'm usually in jeans and a t-shirt.
.TP
d--
My t-shirts go a step further and have a trendy political message on them.
.TP
d---
Punk dresser, including, but not limited to, torn jeans and shirts, body
piercings, and prominent tattoos.
.TP
dx
Cross Dresser
.TP
d?
I have no idea what I am wearing right now, let alone what I wore
yesterday.
.TP
!d
No clothing.  Quite a fashion statement, don't you think?
.TP
dpu
I wear the same clothes all the time, no matter the occasion, forgetting to
do laundry between wearings.
.PD
'''
.SS SHAPE
Geeks come in many shapes and sizes.  Shape code is divided into two parts.
The first indicates height, while the second indicates roundness.  Mix each
section to fit yourself.  Examples include:  s:++, s++:, s++:--.
.sp
.PD 0
.TP 10
s+++:+++
I usually have to duck through doors/I take up three movie seats.
.TP
s++:++
I'm a basketball/linebacker candidate.
.TP
s+:+
I'm a little taller/rounder than most.
.TP
s:
I'm an average geek 
.TP
s-:-
I look up to most people.  Everyone tells me to gain a few pounds.
.TP
s--:--
I look up to damn near everybody.  I tend to have to fight against a strong
breeze.
.TP
s---:---
I take a phone book with me when I go out so I can see to eat dinner.  My
bones are poking through my skin.
.PD
.SS AGE
The only way to become a true geek is through practice and experience.  To
this end, your age becomes an important part of your geekiness.  Use the
qualifiers below to show your age (in Terran years).  Also, please use 
\s-1BASE\s0 10 numbers.
.sp
.PD 0
.TP 10
a+++
60 and up
.TP
a++
50-59
.TP
a+
40-49
.TP
a
30-39
.TP
a-
25-29
.TP
a--
20-24
.TP
a---
15-19
.TP
a----
10-14
.TP
a-----
9 and under (Geek in training?)
.TP
a?
immortal
.TP
!a
it's none of your business how old I am
.PD
.sp
In addition, if you wish to give your exact age, you can place the number
after the \*(L'a\*(R' identifier.  For example:  a42
.SH "SECTION II -- COMPUTERS"
There is a record of geeks that don't use computers.  Unfortunately, they 
are all dead, having lived in an era of no computers.  All modern geeks 
have some exposure to computers.  If you don't know what a computer is, 
you need to go back into your shell.
.SS COMPUTERS
Most geeks identify themselves by their use of computers and computer
networks.  In order to quantify your geekiness level on computers, consult
the following (consider the term \*(L'computers\*(R' synonymous with
\*(L'computer network').  This category represents \*(L"general\*(R"
computer aptitude.  Categories below will get into specifics.
.sp
.PD 0
.TP 10
C++++
I'll be first in line to get the new cybernetic interface installed into my
skull.
.TP
C+++
You mean there is life outside of Internet?  You're shittin' me!  I haven't
dragged myself to class in weeks.
.TP
C++
Computers are a large part of my existence.  When I get up in the morning,
the first thing I do is log myself in.  I play games or mud on weekends,
but still manage to stay off of academic probation.
.TP
C+
Computers are fun and I enjoy using them.  I play a mean game of DOOM!  and
can use a word processor without resorting to the manual too often.  I know
that a 3.5" disk is not a hard disk.  I also know that when it says 'press
any key to continue', I don't have to look for a key labeled 'ANY'.
.TP
C
Computers are a tool, nothing more.  I use it when it serves my purpose.
.TP
C-
Anything more complicated than my calculator and I'm screwed.
.TP
C--
Where's the on switch?
.TP
C---
If you even mention computers, I will rip your head off!
.PD
.SS UNIX
It seems that a Unix-based operating system is the \s-1OS\s0 of choice
among most geeks.  In addition to telling us about your Unix abilities, you
can also show which specific Unix \s-1OS\s0 you are using.  To accomplish
this, you include a letter showing the brand with your rating.  For
example: \s-1UL\s0++++ would indicate a sysadmin running Linux. 
.sp
.PD 0
.TP 10
B
BSD (use this unless your BSDish system is mentioned below)
.TP
L
Linux
.TP
U
Ultrix
.TP
A
AIX
.TP
V
SysV
.TP
H
HPUX
.TP
I
IRIX 
.TP
O
OSF/1 (aka Digital Unix)
.TP
S
Sun OS/Solaris
.TP
C
SCO Unix
.TP
X
NeXT
.TP
*
Some other one not listed
.TP
U++++
I am the sysadmin.  If you try and crack my machine don't be surprised if
the municipal works department gets an "accidental" computer-generated
order to put start a new landfill on your front lawn or your quota is
reduced to 4K.
.TP
U+++
I don't need to crack /etc/passwd because I just modified su so that it
doesn't prompt me.  The admin staff doesn't even know I'm here.  If you
don't understand what I just said, this category does NOT apply to you!
.TP
U++
I've get the entire admin ticked off at me because I am always using all of
the CPU time and trying to run programs that I don't have access to.  I'm
going to try cracking /etc/passwd next week, just don't tell anyone.
.TP
U+
I not only have a Unix account, but I slam VMS any chance I get.
.TP
U
I have a Unix account to do my stuff in
.TP
U-
I have a VMS account.
.TP
U--
I've seen Unix and didn't like it.  DEC rules!
.TP
U---
Unix geeks are actually nerds in disguise.
.PD
.SS PERL
If you enjoy at least U++ status you have to know about Perl, so you
might as well rate yourself in this sub-category.  Non-Unix geeks don't
know what they're missing.
.sp
.PD 0
.TP 10
P+++++
I am Larry Wall, Tom Christiansen, or Randal Schwartz.
.TP
P++++
I don't write Perl, I speak it.  Perl has superseded all other programming
languages.  I firmly believe that all programs can be reduced to a Perl
one-liner.  I use Perl to achieve U+++ status.
.TP
P+++
Perl is a very powerful programming tool.  Not only do I no longer write
shell scripts, I also no longer use awk or sed.  I use Perl for all
programs of less than a thousand lines.
.TP
P++
Perl is a powerful programming tool.  I don't write shell scripts anymore
because I write them in Perl.
.TP
P+
I know of Perl.  I like Perl.  I just haven't learned much Perl, but it is
on my agenda.
.TP
P
I know Perl exists, but that's all.
.TP
P-
What's Perl got that awk and sed don't have?
.TP
P--
Perl users are sick, twisted programmers who are just showing off.
.TP
P---
Perl combines the power of sh, the clarity of sed, and the performance of
awk with the simplicity of C.  It should be banned.
.TP
P!
Our paranoid admin won't let us install Perl!  Says it's a "hacking tool".
.PD
.SS LINUX
Linux is a hacker-written operating system virtually identical to Unix.  It
was written for and continues to run on your standard 386/486/Pentium
\s-1PC\s0, but has also being ported to other systems.  Because it is still
a young \s-1OS\s0, and because it is continually evolving from hacker
changes and support, it is important that the geek list his Linux ability. 
.sp
.PD 0
.TP 10
L+++++
I am Linus, grovel before me.
.TP
L++++
I am a Linux wizard.  I munch C code for breakfast and have enough room
left over for a kernel debugging.  I have so many patches installed that I
lost track about ten versions ago.  Linux newbies consider me a net.god.
.TP
L+++
I use Linux exclusively on my system.  I monitor comp.os.linux.* and even
answer questions sometimes.
.TP
L++
I use Linux ALMOST exclusively on my system.  I've given up trying to
achieve Linux.God status, but welcome the OS as a replacement for DOS.  I
only boot to DOS to play games.
.TP
L+
I've managed to get Linux installed and even used it a few times.  It seems
like it is just another OS.
.TP
L
I know what Linux is, but that's about all
.TP
L-
I have no desire to use Linux and frankly don't give a rats patootie about
it.  There are other, better, operating systems out there.  Like Mac, DOS,
or Amiga-OS.  Or, better yet even, would be another free Unix OS like
FreeBSD.
.TP
L--
Unix sucks.  Because Linux = Unix.  Linux Sucks.  I worship Bill Gates.
.TP
L---
I am Bill Gates.
.PD
.SS EMACS
\s-1GNU\s0 Emacs is the do-all be-everything editor/operating system
available for just about every computer architecture out there. 
.sp
.PD 0
.TP 10
E+++
Emacs is my login shell!!  M-x doctor is my psychologist!  I use emacs to
control my TV and toaster oven!  All you vi people don't know what you're
missing!  I read alt.religion.emacs, alt.sex.emacs, and comp.os.emacs.
.TP
E++
I know and use elisp regularly!
.TP
E+
Emacs is great! I read my mail and news with it!
.TP
E
Yeah, I know what emacs is, and use it as my regular editor.
.TP
E-
Emacs is too big and bloated for my tastes
.TP
E--
Emacs is just a fancy word processor
.TP
E---
Emacs sucks! vi forever!!!
.TP
E----
Emacs sucks! pico forever!!!
.PD
.SS "WORLD WIDE WEB"
It's relatively new.  It's little understood.  Everybody's doing it.  How 
much of a web-surfer are you?
.sp
.PD 0
.TP 10
W+++
I am a WebMaster.  Don't even think about trying to view my homepage
without the latest version of Netscape.  When I'm not on my normal net
connection, I surf the web using my Newton and a cellular modem.
.TP
W++
I have a homepage.  I surf daily.  My homepage is advertised in my
.signature.
.TP
W+
I have the latest version of Netscape, and wander the web only when there's
something specific I'm looking for.
.TP
W
I have a browser and a connection.  Occasionally I'll use them.
.TP
W-
The web is really a pain.  Life was so much easier when you could transfer
information by simple ASCII.  Now everyone won't even consider your ideas
unless you spiff them up with bandwidth-consuming pictures and pointless
information links.
.TP
W--
A pox on the Web!  It wastes time and bandwidth and just gives the
uneducated morons a reason to clutter the Internet.
.PD
.SS "USENET NEWS"
Usenet, a global collection of flaming opinions and senseless babble, was
designed as a way to eat up precious spool space on a system's hard drive. 
It also is a way for people to distribute pornography.
.sp
.PD 0
.TP 10
N++++
I am Tim Pierce
.TP
N+++
I read so many newsgroups that the next batch of news comes in before I
finish reading the last batch, and I have to read for about 2 hours
straight before I'm caught up on the morning's news.  Then there's the
afternoon...
.TP
N++
I read all the news in a select handful of groups.
.TP
N+
I read news recreationally when I have some time to kill.
.TP
N
Usenet News?  Sure, I read that once
.TP
N-
News is a waste of my time and I avoid it completely
.TP
N--
News sucks!  'Nuff said.
.TP
N---
I work for Time Magazine.
.TP
N----
I am a Scientologist.
.TP
N*
All I do is read news
.PD
.SS "USENET ORACLE"
(Info taken from the Usenet Oracle Help File)
Throughout the history of mankind, there have been many Oracles who
have been consulted by many mortals, and some immortals.  The great
Hercules was told by the Delphic Oracle to serve Eurystheus, king of
Mycenae, for twelve years to atone for the murder of his own children.
It was the Oracle of Ammon who told King Cepheus to chain his daughter
Andromeda to the rocks of Joppa to appease the terrible sea monster
that was ravaging the coasts.  That solution was never tested, though,
as Perseus saved the girl in the nick of time.
.PP
With the advent of the electronic age, and especially high-speed e-mail
communication, the spirit of the Oracles found a new outlet, and we now
recognize another great Oracle, the Usenet Oracle.
.PP
For more information, check out the newsgroups rec.humor.oracle and
rec.humor.oracle.d or the \s-1FTP\s0 archives at cs.indiana.edu:/pub/oracle. 
Additional information and instructions can be found by sending an email
message with the subject of \*(L'help\*(R' to oracle@cs.indiana.edu. 
.sp
.PD 0
.TP 10
o+++++
I am Steve Kinzler
.TP
o++++
I am an active Priest
.TP
o+++
I was a Priest, but have retired.
.TP
o++
I have made the Best Of Oracularities
.TP
o+
I have been incarnated at least once.
.TP
o
I've submitted a question, but it has never been incarnated.
.TP
o-
I sent my question to the wrong group and got flamed.
.TP
o--
Who needs answers from a bunch of geeks anyhow?
.PD
.SS KIBO
Kibo is.  That is all that can be said.  If you don't understand, read 
alt.religion.kibology.
.sp
.PD 0
.TP 10
K++++++
I am Kibo
.TP
K+++++
I've had sex with Kibo
.TP
K++++
I've met Kibo
.TP
K+++
I've gotten mail from Kibo
.TP
K++
I've read Kibo
.TP
K+
I like Kibo
.TP
K
I know who Kibo is
.TP
K-
I don't know who Kibo is
.TP
K--
I dislike Kibo
.TP
K---
I am currently hunting Kibo down with the intent of ripping his
still-beating heart out of his chest and showing it to him as he dies
.TP
K----
I am Xibo
.PD
.SS "MICROSOFT WINDOWS"
A good many geeks suffer through the use of various versions of
Microsoft's Windows running on or as a replacement for \s-1DOS\s0.  Rate your
Windows Geekiness. 
.sp
.PD 0
.TP 10
w+++++
I am Bill Gates
.TP
w++++
I have Windows, Windows 95, Windows NT, and Windows NT Advanced Server all
running on my SMP RISC machine.  I haven't seen daylight in six months.
.TP
w+++
I am a MS Windows programming god.  I wrote a VxD driver to allow MS
Windows and DOS to share the use of my waffle iron.  P.S.  Unix sux.
.TP
w++
I write MS Windows programs in C and think about using C++ someday.  I've
written at least one DLL.
.TP
w+
I have installed my own custom sounds, wallpaper, and screen savers so my
PC walks and talks like a fun house.  Oh yeah, I have a hundred
TrueType(tm) fonts that I've installed but never used.  I never lose
Minesweeper and Solitaire
.TP
w
Ok, so I use MS Windows, I don't have to like it.
.TP
w-
I'm still trying to install MS Windows and have at least one peripheral
that never works right
.TP
w--
MS Windows is a joke operating system.  Hell, it's not even an operating
system.  NT is Not Tough enough for me either.  95 is how may times it will
crash an hour.
.TP
w---
Windows has set back the computing industry by at least 10 years.  Bill
Gates should be drawn, quartered, hung, shot, poisoned, disembowelled, and
then REALLY hurt.
.PD
.SS OS/2
The operating system that looks a lot like Windows, acts a lot like 
Windows, but is much better than Windows.
.sp
.PD 0
.TP 10
O+++
I live, eat and breathe OS/2.  All of my hard drives are HPFS.  I am the
Anti-Gates.
.TP
O++
I use OS/2 for all my computing needs.  I use some DOS and Windows
programs, but run them under OS/2.  If the program won't run under OS/2,
then obviously I don't need it.
.TP
O+
I keep a DOS partition on my hard drive "just in case".  I'm afraid to try
HPFS.
.TP
O
I finally managed to get OS/2 installed but wasn't too terribly impressed.
.TP
O-
Tried it, didn't like it.
.TP
O--
I can't even get the thing to install!
.TP
O---
Windows RULES!!!  Long live Bill Gates. (See w++++)
.TP
O----
I am Bill Gates of Borg.  OS/2 is irrelevant.
.PD
.SS MACINTOSH
Many geeks have abandoned the character-based computer altogether and
moved over to the Macintosh.  It is important to give notification of your
Mac rating. 
.sp
.PD 0
.TP 10
M++
I am a Mac guru.  Anything those DOS putzes and Unix nerds can do, I can do
better, and if not, I'll write the damn software to do it.
.TP
M+
A Mac has its uses and I use it quite often.
.TP
M
I use a Mac, but I'm pretty indifferent about it.
.TP
M-
Macs suck.  All real geeks have a character prompt.
.TP
M--
Macs do more than suck.  They make a user stupid by allowing them to use
the system without knowing what they are doing.  Mac weenies have lower IQs
than the fuzz in my navel.
.PD
.SS VMS
Many geeks use the \s-1VMS\s0 operating system by \s-1DEC\s0 for all of
their mainframe and network activity.
.sp
.PD 0
.TP 10
V+++
I am a VMS sysadmin.  I wield far more power than those UNIX admins,
because UNIX can be found on any dweeb's desktop.  Power through obscurity
is my motto.
.TP
V++
Unix is a passing fad compared to the real power in the universe, my VMS
system.
.TP
V+
I tend to like VMS better than Unix
.TP
V
I've used VMS.
.TP
V-
Unix is much better than VMS for my computing needs.
.TP
V--
I would rather smash my head repeatedly into a brick wall than suffer the
agony of working with VMS.  It's reminiscent of a dead and decaying pile of
moose droppings.  Unix rules the universe.
.PD
.SH "SECTION III -- POLITICS"
The last few years has seen the rise of the political geek.  This phenomena
is little understood, but some theorize that it has come about because of
the popular media's attempts to demonize the Internet and computer use in
general, and the government's willingness to go along with it.  Others
propose that the aging geek population has simply started taking an
interest in the world around them.  Some support the \*(L"Sun Spot\*(R"
theory. 
.SS "POLITICS AND SOCIAL ISSUES"
We live is a society where everyone not only has a right to, but is 
expected to, whine and complain about everyone else.  Rate where, in 
general, your political views on different social issues fall.
.sp
.PD 0
.TP 10
PS+++
Legalize drugs!  Abolish the government.  "Fuck the draft!"
.TP
PS++
I give to liberal causes.  I march for gay rights.  I'm a card carrying
member of the ACLU.  Keep abortion safe and legal.
.TP
PS+
My whole concept of liberalism is that nobody has the right to tell anybody
else what to do, on either side of the political fence.  If you don't like
it, turn the bloody channel.
.TP
PS
I really don't have an opinion; nobody's messing with my freedoms right
now.
.TP
PS-
Label records!  Keep dirty stuff off the TV and the Internet.
.TP
PS--
Oppose sex education, abortion rights, gay rights.  Rush Limbaugh is my
spokeman.
.TP
PS---
Repent left-wing sinners and change your wicked evil ways. 
Buchanan/Robertson in '96.
.PD
.SS "POLITICS AND ECONOMIC ISSUES"
Social and economic attitudes are seldom on the same side of the 
political fence.  Of course, most geeks don't really care much about 
economics; having no money left after buying new computer toys.
.sp
.PD 0
.TP 10
PE+++
Abolish antitrust legislation.  Raise taxes on everyone but the rich so
that the money can trickle-down to the masses.
.TP
PE++
Keep the government off the backs of businesses.  Deregulate as much as
possible.
.TP
PE+
Balance the budget with spending cuts and an amendment.
.TP
PE
Distrust both government and business.
.TP
PE-
It's ok to increase government spending, so we can help more poor people. 
Tax the rich!  Cut the defense budget!
.TP
PE--
Capitalism is evil!  Government should provide the services we really need. 
Nobody should be rich.
.PD
.SS CYPHERPUNKS
With the birth of the overused buzzword \*(L"The Information
Superhighway\*(R", concerns over privacy from evil governmental
bad-guys{tm} has led to the formation of an unofficial, loosely organized
band of civil libertarians who spend much of their time discussing how to
ensure privacy in the information future.  This group is known by some as
\*(L"cypherpunks\*(R" (by others, as anarchistic subversives).  To this
end, tell us how punkish you are. 
.sp
.PD 0
.TP 10
Y+++
I am T.C. May
.TP
Y++
I am on the cypherpunks mailing list and active around Usenet.  I never
miss an opportunity to talk about the evils of Clipper and ITAR and the
NSA.  Orwell's 1984 is more than a story, it is a warning to our's and
future generations.  I'm a member of the EFF.
.TP
Y+
I have an interest and concern in privacy issues, but in reality I am not
really all that active or vocal.
.TP
Y
I'm pretty indifferent on the whole issue.
.TP
Y-
It seems to me that all of these concerns are a little extreme.  I mean,
the government must be able to protect itself from criminals and the
populace from indecent speech.
.TP
Y--
Get a life.  The only people that need this kind of protection are people
with something to hide.  I think cypherpunks are just a little paranoid.
.TP
Y---
I am L. Detweiler.
.PD
.SS PGP
Pretty Good Privacy (aka \s-1PGP\s0) is a program available on many platforms 
that will encrypt files so that prying eyes (particularly governmental) 
can't look at them. 
.sp
.PD 0
.TP 10
PGP++++
I am Philip Zimmerman
.TP
PGP+++
I don't send or answer mail that is not encrypted, or at the very least
signed.  If you are reading this without decrypting it first, something is
wrong.  IT DIDN'T COME FROM ME!
.TP
PGP++
I have the most recent version and use it regularly
.TP
PGP+
"Finger me for my public key"
.TP
PGP
I've used it, but stopped long ago.
.TP
PGP-
I don't have anything to hide.
.TP
PGP--
I feel that the glory of the Internet is in the anarchic, trusting
environment that so nurtures the exchange of information.  Encryption just
bogs that down.
.TP
PGP---
If you support encryption on the Internet, you must be a drug dealer or
terrorist or something like that.
.TP
PGP----
Oh, here is something you all can use that is better (insert Clipper here).
.PD
.SH "SECTION IV -- ENTERTAINMENT"
Geeks love to play.  No matter their age, all geeks enjoy playing.  Of
course, the object of this entertainment takes a myriad of different forms. 
What is it that pushes a geek to play?  Is it simply a desire to relive 
their childhood?  Or perhaps there is a piece of geeky genetic code that
requires intellectual stimulation.  Who knows, maybe it's a Freudian
thing... 
.SS "STAR TREK"
Most geeks have an undeniable love for the Star Trek television show (in
any of its different incarnations).  Because \s-1GEEK\s0 is often
synonymous with \s-1TREKKIE\s0 (real geeks aren't so anal as to label
themselves \s-1TREKKER\s0), it is important that all geeks list their Trek
rating. 
.sp
.PD 0
.TP 10
t+++
It's not just a TV show, it's a religion.  I know all about warp field
dynamics and the principles behind the transporter.  I have memorized the
TECH manual.  I speak Klingon.  I go to cons with Vulcan ears on.  I have
no life.
.TP
t++
It's the best show around.  I have all the episodes and the movies on tape
and can quote entire scenes verbatim.  I've built a few of the model kits
too.  But you'll never catch me at one of those conventions.  Those people
are kooks.
.TP
t+
It's a damn fine TV show and is one of the only things good on television
any more.
.TP
t
It's just another TV show
.TP
t-
Maybe it is just me, but I have no idea what the big deal with Star Trek
is.  Perhaps I'm missing something but I just think it is bad drama.
.TP
t--
Star Trek is just another Space Opera.  William Shatner isn't an actor,
he's a poser!  And what's with this Jean-Luc Picard?  A Frenchman with a
British accent?  Isn't Voyager just a rehash of Lost in Space?  Has Sisko
even breathed in the last two seasons?  Come on.  I'd only watch this show
if my remote control broke.
.TP
t---
Star Trek SUCKS!  It is the worst crap I have ever seen!  Hey, all you
trekkies out there, GET A LIFE! (William Shatner is a t---)
.TP
t*
I identify with Barclay, the greatest of the Trek Geeks.
.PD
.SS "Babylon 5"
For many years, Sci-Fi geeks have wished for a television show that would
overcome the limitations of Star Trek.  For many, a show called Babylon 5
has met that demand, with a deep storyline, exciting characters and
state-of-the-art computer generated effects. 
.sp
.PD 0
.TP 10
5++++
I am J. Michael Straczynski
.TP
5+++
I am a True Worshipper of the Church of Joe who lives eats breathes and
thinks Babylon 5, and has Evil thoughts about stealing Joe's videotape
archives just to see episodes earlier.  I am planning to break into the
bank and steal the triple-encoded synopsis of the 5-year arc.
.TP
5++
Finally a show that shows what a real future would look like.  None of this
Picardian "Let's talk about it and be friends" crap.  And what's this?  We
finally get to see a bathroom!  Over on that Enterprise, they've been
holding it for over seven years!
.TP
5+
Babylon 5 certainly presents a fresh perspective in the Sci-Fi universe.  I
watch it weekly.
.TP
5
I've seen it, I am pretty indifferent to it.
.TP
5-
This show is sub-par.  The acting is wooden, the special effects are
obviously poor quality.  In general, it seems like a very cheap Star Trek
ripoff.
.TP
5--
You call this Sci-Fi?  That is such a load of crap!  This show is just a
soap with bad actors, piss-poor effects, and lame storylines.  Puh-leese.
.PD
.SS "THE X-FILES"
The Fox Network's Friday evening show The X\-Files has become the staple 
of Friday geekhood.  Any show that has aliens, governmental conspiracies, 
aliens, psychic powers, aliens, and other weird stuff is, by definition, 
a geeky show.
.sp
.PD 0
.TP 10
X++++
I am Chris Carter
.TP
X+++
This is the BEST show on TV, and it's about time.  I've seen everything
David Duchovny and Gillian Anderson have ever done that been recorded and
I'm a loyal Duchovny/ Gillian Anderson fan.  I've Converted at least 10
people.  I have every episode at SP, debate the fine details on-line, and
have a credit for at least 2 YAXAs.
.TP
X++
This is one of the better shows I've seen.  I wish I'd taped everything
from the start at SP, because I'm wearing out my EP tapes.  I'll
periodically debate online.  I've Converted at least 5 people.  I've gotten
a YAXA.
.TP
X+
I've Converted my family and watch the show when I remember.  It's really
kinda fun.
.TP
X
Ho hum.  Just another Fox show.
.TP
X-
It's ok if you like paranoia and conspiracy stories, but, let's face it,
it's crap.
.TP
X--
If I wanted to watch this kind of stuff, I'd talk to Oliver Stone
.PD
.SS "ROLE-PLAYING"
Role-playing games such as Dungeons & Dragons have long been a part of the
traditional geek life.  Because geeks often become so involved in their
role-playing that they lose touch with reality, include one of the following
role-playing codes.
.sp
.PD 0
.TP 10
R+++
I've written and published my own gaming materials.
.TP
R++
There is no life outside the role of the die.  I know all of the piddly
rules of (chosen game).  _MY_ own warped rules scare the rest of the
players.
.TP
R+
I've got my weekly sessions set up and a character that I know better than
I know myself.
.TP
R
Role-Playing?  That's just something to do to kill a Saturday afternoon
.TP
R-
Gosh, what an utter waste of time!
.TP
R--
Role-Players are instruments of pure evil.
.TP
R---
I work for T$R.
.TP
R*
I thought life WAS role-playing?
.PD
.SS TELEVISION
Many geeks have lives that revolve around television.
.sp
.PD 0
.TP 10
tv+++
There's nothing I can experience "out there" that I can't see coming over
my satellite dish.  I wish there were MORE channels.  I live for the O.J. 
Trial.
.TP
tv++
I just leave the tv on, to make sure I don't miss anything.
.TP
tv+
I watch some tv every day.
.TP
tv
I watch only the shows that are actually worthwhile, such as those found on
PBS.
.TP
tv-
I watch tv for the news and 'special programming.'
.TP
tv--
I turn my tv on during natural disasters.
.TP
tv---
I do not own a television.
.PD
.SS BOOKS
In addition (or maybe on the other hand), many geeks have lives that revolve 
around books.
.sp
.PD 0
.TP 10
b++++
I read a book a day.  I have library cards in three states.  I have
discount cards from every major bookstore.  I've ordered books from another
country to get my Favorite Author Fix.
.TP
b+++
I consume a few books a week as part of a staple diet.
.TP
b++
I find the time to get through at least one new book a month.
.TP
b+
I enjoy reading, but don't get the time very often.
.TP
b
I read the newspaper and the occasional book.
.TP
b-
I read when there is no other way to get the information.
.TP
b--
I did not actually READ the geek code, I just had someone tell me.
.PD
.SS DILBERT
Simply the geekiest comic strip in existence.  
http://www.unitedmedia.com/comics/dilbert/ for more information.
.sp
.PD 0
.TP 10
DI+++++
I am Scott Adams.
.TP
DI++++
I've received mail from Scott Adams.  I'm in the DNRC (Dogbert's New Ruling
Class).
.TP
DI+++
I am a Dilbert prototype
.TP
DI++
I work with people that act a lot like Dilbert and his boss.
.TP
DI+
I read Dilbert daily, often understanding it
.TP
DI
I read Dilbert infrequently, rarely understanding it
.TP
DI-
Is that the comic about the engineers?
.TP
DI--
Don't read it, but I think the dog is kinda cute.
.TP
DI---
I don't think it's funny to make fun of managers trying their best to run
their organizational units.
.PD
.SS DOOM!
There is a game out for the PCs and other computers called \s-1DOOM\s0.
It's a 3D virtual reality simulation where you race around and blow
things away with large-caliber weaponry.  This has led to a series of
similar games such as the Star Wars themed Dark Forces.  Tell us
about your abilities with these 3D games.  (yes, some of them aren't
actually Doom.  Cope!)
.sp
.PD 0
.TP 10
D++++
I work for iD Software.        
.TP
D+++
I crank out PWAD files daily, complete with new monsters, weaponry, sounds
and maps.  I'm a DOOM God.  I can solve the original maps in nightmare mode
with my eyes closed.
.TP
D++
I've played the shareware version and bought the real one and I'm actually
pretty good at the game.  I occasionally download PWAD files and play them
too.
.TP
D+
It's a fun, action game that is a nice diversion on a lazy
afternoon.
.TP
D
I've played the game and I'm pretty indifferent.
.TP
D-
I've played the game and really didn't think it was all that impressive.
.TP
D--
It's an overly-violent game and pure crap
.TP
D---    To hell with Doom, I miss Zork.
.TP
D----
I've seen better on my Atari 2600
.PD
.SS "THE GEEK CODE"
The \fIGeek Code\fR has become an important part of the Geek Experience.  All
true geeks recognize the \fIGeek Code\fR, and some can even recite it. 
.sp
.PD 0
.TP 10
G+++++
I am Robert Hayden
.TP
G++++
I have made a suggestion for future versions of the code (note that making
a suggestion just to get a G++++ rating doesn't count, you also have to at
least qualify for a G+++ rating :-)
.TP
G+++
I have memorized the entire geek code, and can decode others' codes in my
head.  I know by heart where to find the current version of the code on the
net.
.TP
G++
I know what each letter means, but sometimes have to look up the specifics.
.TP
G+
I was once G++ (or higher), but the new versions are getting too long and
too complicated.
.TP
G
I know what the geek code is and even did up this code.
.TP
G-
What a tremendous waste of time this \fIGeek Code\fR is.
.TP
G--
Not only a waste of time, but it obviously shows that this
Hayden guy needs a life.
.PD
.SH "SECTION V -- LIFESTYLE"
Geeks, unlike the lower lifeforms known as nerds, have lives.  They have
things to do that are in the outside world.  Of course, this is usually
done with other geeks, but that's not the point.  The point is that geeks
are not necessarily the outcasts society often believes they are. 
The fact is that society isn't kool enough to be included in our
activities.
.SS EDUCATION
All geeks have a varying amount of education.
.sp
.PD 0
.TP 10
e+++++
I am Stephen Hawking
.TP
e++++
Managed to get my Ph.D.
.TP
e+++
Got a Masters degree
.TP
e++
Got a Baccalaureate degree
.TP
e+
Got an Associate degree
.TP
e
Finished High School
.TP
e-
Haven't finished High School
.TP
e--
Haven't even entered High School
.TP
e*
I learned everything there is to know about life from the "Hitchhiker's
Trilogy".
.PD
.SS HOUSING
Tell us about your geeky home.
.sp
.PD 0
.TP 10
h++
Living in a cave with 47 computers and an Internet feed,
located near a Dominoes pizza.  See !d.
.TP
h+
Living alone, get out once a week to buy food, no more than once a month to
do laundry.  All surfaces covered.
.TP
h
Friends come over to visit every once in a while to talk about Geek things. 
There is a place for them to sit.
.TP
h-
Living with one or more registered Geeks.
.TP
h--
Living with one or more people who know nothing about being a Geek and
refuse to watch Babylon 5.
.TP
h---
Married, (persons living romantically with someone might as well label
themselves h---, you're as good as there already.)
.TP
h----
Married with children - Al Bundy can sympathize
.TP
h!
I am stuck living with my parents!
.TP
h*
I'm not sure where I live anymore.  This lab/workplace seems like home to
me.
.PD
.SS RELATIONSHIPS
While many geeks are highly successful at having relationships, a good
many more are not.  Give us the gritty details. 
.sp
.PD 0
.TP 10
r+++
Found someone, dated, and am now married.
.TP
r++
I've dated my current S.O. for a long time.
.TP
r+
I date frequently, bouncing from one relationship to another.
.TP
r
I date periodically.
.TP
r-
I have difficulty maintaining a relationship.
.TP
r--
People just aren't interested in dating me.
.TP
r---
I'm beginning to think that I'm a leper or something, the way people avoid
me like the plague.
.TP
!r
I've never had a relationship.
.TP
r*
signifying membership in the SBCA (Sour Bachelor(ette)'s Club of America). 
The motto is 'Bitter, but not Desperate'.  First founded at Caltech.
.TP
r%
I was going out with someone, but the asshole dumped me.
.PD
.Sh "\s-1SEX\s0"
Geeks have traditionally had problems with sex (ie, they never have any).
Because geeks are so wrapped up in their sexuality (or lack of sexuality for
that matter), it is important that the geek be willing to quantify their
sexual experiences.
.PP
This code also is used to denote the gender of the geek.  Females use
\*(L'x\*(R' in this category, while males use \*(L'y\*(R'.  Those that do
not wish to disclose their gender can use \*(L'z\*(R'.  For example:
.sp
.PD 0
.TP 10
x+
A female who has had sex
.TP
y+
A male who has had sex.
.TP
z+
A person (gender undisclosed) who has had sex.
.PD
For those persons who do not wish to give out any details of their sex life,
the use of z? (where z is the gender code) will allow you to do so.
.sp
.PD 0
.TP 10
x+++++
I am Madonna
.TP
z++++
I have a few little rug rats to prove I've been there.  Besides, with kids
around, who has time for sex?
.TP
z+++
I'm married, so I can get it (theoretically) whenever I want.
.TP
z++
I was once referred to as 'easy'.  I have no idea where that might have
come from though.
.TP
z+
I've had real, live sex.
.TP
z
I've had sex.  Oh!  You mean with someone else?  Then no.
.TP
z-
Not having sex by choice.
.TP
z--
Not having sex because I just can't get any...
.TP
z---
Not having sex because I'm a nun or a priest.
.TP
z*
I'm a pervert.
.TP
z**
I've been known to make perverts look like angels.
.TP
!z
Sex?  What's that?  I've had no sexual experiences.
.TP
z?
It's none of your business what my sex life is like (this is used to denote
your gender only).
.TP
!z+
Sex? What's that? No experience, willing to learn!
.PD
.SH "HOW TO DISPLAY YOUR CODE"
Now that you have your ratings for each of the above categories, it's 
time to assemble your code for displaying to the world.  Take each 
category you determined and list them all together with one space between 
each one.  If you run out space on one line, continue it on the next.  
When completed, it will look something like the following:
                
GED/J d-- s:++>: a-- \*(C+(++++) ULU++ P+ L++ E---- W+(\-) N++++ o+ K+++
w--- O\- M+ V-- PS++>$ PE++>$ Y++ PGP++ t- 5+++ X++ R+++>$ tv+ b+
DI+++ D+++ G+++++ e++ h r-- y++**
.PP
If you are going to place your \fIGeek Code\fR into your .signature or .plan
file (highly recommended), you should create your GEEK CODE BLOCK.  This
parody of the output created by the PGP program will attempt to
universalize how you will see the \fIGeek Code\fR around the net.  Your GEEK
CODE BLOCK will look like the following: 
.PP
.Ex
 -----BEGIN GEEK CODE BLOCK-----
 Version: 3.1
 GED/J d-- s:++>: a-- C++(++++) ULU++ P+ L++ E---- W+(-)
 N++++ o+ K+++ w--- O- M+ V-- PS++>$ PE++>$ Y++ PGP++ t- 
 5+++ X++ R+++>$ tv+ b+ DI+++ D+++ G+++++ e++ h r-- y++**
 ------END GEEK CODE BLOCK------
.Ef
.PP
As you can see, the actual code hasn't changed.  However, the version 
number of the code you are using is displayed along with lines starting 
and ending the code.  Make sure to duplicate the start and end lines 
exactly as the example in order to maintain a net-wide standard (ie. five 
dashes front and back for the BEGIN line and six for the END line, and all 
capital letters.)
.PP
"HELP!" you scream as your mailer or news reader won't let you post more 
than four lines in the .signature.  That is because some anal programs 
limit the size of your signature.  Your next best bet, then is to put 
your GEEK CODE BLOCK into your .plan file and put something to the effect 
of "Finger for Geek Code" into your .signature.  That, or get a better 
mailer.
.SH "WHERE TO FIND THE GEEK CODE"
The \fIGeek Code\fR is available at the following OFFICIAL sites.  All other 
sites are not official:
.PP
.Ex
   VIA WORLD WIDE WEB
   http://krypton.mankato.msus.edu/~hayden/geek.html
      (HTML Format)
   gopher://vax1.mankato.msus.edu:79/Rhayden
      (ascii format only)
.Ef
.PP
.Ex
   VIA FINGER
   finger hayden@vax1.mankato.msus.edu
      (ascii format only)
.Ef
.PP
.SH "WHERE TO FIND AN INTERPRETER FOR THE CODE"
In case you don't rate a G+++ in the "Geek Code" category, several 
interpreters have been written for your use.  A UNIX/Perl version (ungeek)
is available from Pete Williams <petew@lexis-nexis.com>.  To get a copy of
this via ftp at the following location:
.PP
.Ex
   FTP: ftp.std.com
   DIR: pub/comp.unix.sources/volume14/ungeek.tar.gz 
.Ef
.PP
or, send the following mail:
.PP
.Ex
   To: petew@lexis-nexis.com
   Subject: Command

   @SH mailhelp PATH
.Ef
.PP
and you'll get instructions (PATH stands for YOUR e-mail address,
either in INTERNET or in bang notation).  You'll be provided henceforth
with further instructions on how to obtain the distribution.
.PP
Other interpreters are available;  point your web browser at the site
mentioned above for further details.
.PP
.SH "COPYRIGHT"
The \fIGeek Code\fR is copyright (C) 1993, 1994, 1995 by Robert A. Hayden.  All
rights reserved.  You are free to distribute this code in electronic
format provided that the file remains unmodified and this copyright notice
remains attached.  This copyright prohibits HTMLizing the code for
publication on the web.  If you wish to publish abstracts or portions of
the code, contact the author for permission.  If you wish to write an
article about the \fIGeek Code\fR, please contact the author.  All creatures not
native to Earth are exempt from this copyright, however, they must prove 
that they qualify.
.SH AUTHOR
Robert A. Hayden <krypton.mankato.msus.edu>
.sp 0
Manual page format by Pete Williams <petew@lexis-nexis.com>
.SH "AUTHOR'S GEEK CODE BLOCK "
.PP
.Ex
 -----BEGIN GEEK CODE BLOCK-----
 Version: 3.1
 GED/J d-- s:++>: a-- C++(++++) ULU++ P+ L++ E---- W+(-) 
 N++++ o+ K+++ w--- O- M+ V-- PS++>$ PE++>$ Y++ PGP++ t- 
 5+++ X++ R+++>$ tv+ b+ DI+++ D+++ G+++++ e++ h r-- y++**
 ------END GEEK CODE BLOCK------
.Ef
.PP
.SH "SEE ALSO"
\fIungeek\fR($manext)
!GROK!THIS!
chmod 444 geekcode.$manext
