#include <u.h>
#include <libc.h>
#include <libsec.h>

static void
printblock(uchar *b, usize n)
{
	int i;

	for(i=0; i+8<=n; i+=8){
		print("%#.2ux %#.2ux %#.2ux %#.2ux %#.2ux %#.2ux %#.2ux %#.2ux\n",
			b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7]);
		b += 8;
	}
	if(i < n){
		print("%#.2ux", *b++);
		while(++i < n)
			print(" %#.2ux", *b++);
		print("\n");
	}
}

/* test vector from RFC7539 */
uchar	rfckey[] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f};
uchar	rfcnonce[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x00};
u32int	rfccount = 1;
char	rfctext[] = "Ladies and Gentlemen of the class of '99: If I could offer you only one tip for the future, "
	"sunscreen would be it.";
uchar	rfcout[3*ChachaBsize];
uchar	rfcref[] = {
	0x6e, 0x2e, 0x35, 0x9a, 0x25, 0x68, 0xf9, 0x80, 0x41, 0xba, 0x07, 0x28, 0xdd, 0x0d, 0x69, 0x81,
	0xe9, 0x7e, 0x7a, 0xec, 0x1d, 0x43, 0x60, 0xc2, 0x0a, 0x27, 0xaf, 0xcc, 0xfd, 0x9f, 0xae, 0x0b,
	0xf9, 0x1b, 0x65, 0xc5, 0x52, 0x47, 0x33, 0xab, 0x8f, 0x59, 0x3d, 0xab, 0xcd, 0x62, 0xb3, 0x57,
	0x16, 0x39, 0xd6, 0x24, 0xe6, 0x51, 0x52, 0xab, 0x8f, 0x53, 0x0c, 0x35, 0x9f, 0x08, 0x61, 0xd8,
	0x07, 0xca, 0x0d, 0xbf, 0x50, 0x0d, 0x6a, 0x61, 0x56, 0xa3, 0x8e, 0x08, 0x8a, 0x22, 0xb6, 0x5e,
	0x52, 0xbc, 0x51, 0x4d, 0x16, 0xcc, 0xf8, 0x06, 0x81, 0x8c, 0xe9, 0x1a, 0xb7, 0x79, 0x37, 0x36,
	0x5a, 0xf9, 0x0b, 0xbf, 0x74, 0xa3, 0x5b, 0xe6, 0xb4, 0x0b, 0x8e, 0xed, 0xf2, 0x78, 0x5e, 0x42,
	0x87, 0x4d
};

uchar	xcckey[] = {
	0x1b, 0x27, 0x55, 0x64, 0x73, 0xe9, 0x85, 0xd4, 0x62, 0xcd, 0x51, 0x19, 0x7a, 0x9a, 0x46, 0xc7,
	0x60, 0x09, 0x54, 0x9e, 0xac, 0x64, 0x74, 0xf2, 0x06, 0xc4, 0xee, 0x08, 0x44, 0xf6, 0x83, 0x89,
};
uchar	xcciv[] = {
	0x69, 0x69, 0x6e, 0xe9, 0x55, 0xb6, 0x2b, 0x73, 0xcd, 0x62, 0xbd, 0xa8, 0x75, 0xfc, 0x73, 0xd6,
	0x82, 0x19, 0xe0, 0x03, 0x6b, 0x7a, 0x0b, 0x37,
};
uchar	xccref[] = {
	0x4f, 0xeb, 0xf2, 0xfe, 0x4b, 0x35, 0x9c, 0x50, 0x8d, 0xc5, 0xe8, 0xb5, 0x98, 0x0c, 0x88, 0xe3,
	0x89, 0x46, 0xd8, 0xf1, 0x8f, 0x31, 0x34, 0x65, 0xc8, 0x62, 0xa0, 0x87, 0x82, 0x64, 0x82, 0x48,
	0x01, 0x8d, 0xac, 0xdc, 0xb9, 0x04, 0x17, 0x88, 0x53, 0xa4, 0x6d, 0xca, 0x3a, 0x0e, 0xaa, 0xee,
	0x74, 0x7c, 0xba, 0x97, 0x43, 0x4e, 0xaf, 0xfa, 0xd5, 0x8f, 0xea, 0x82, 0x22, 0x04, 0x7e, 0x0d,
	0xe6, 0xc3, 0xa6, 0x77, 0x51, 0x06, 0xe0, 0x33, 0x1a, 0xd7, 0x14, 0xd2, 0xf2, 0x7a, 0x55, 0x64,
	0x13, 0x40, 0xa1, 0xf1, 0xdd, 0x9f, 0x94, 0x53, 0x2e, 0x68, 0xcb, 0x24, 0x1c, 0xbd, 0xd1, 0x50,
	0x97, 0x0d, 0x14, 0xe0, 0x5c, 0x5b, 0x17, 0x31, 0x93, 0xfb, 0x14, 0xf5, 0x1c, 0x41, 0xf3, 0x93,
	0x83, 0x5b, 0xf7, 0xf4, 0x16, 0xa7, 0xe0, 0xbb, 0xa8, 0x1f, 0xfb, 0x8b, 0x13, 0xaf, 0x0e, 0x21,
	0x69, 0x1d, 0x7e, 0xce, 0xc9, 0x3b, 0x75, 0xe6, 0xe4, 0x18, 0x3a,
};

uchar	ccpaad[] = {
	0x50, 0x51, 0x52, 0x53, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
};
uchar	ccpkey[] = {
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
};
uchar	ccpiv[] = {
	0x07, 0x00, 0x00, 0x00,  
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
};
uchar	ccptag[] = {
	0x1a, 0xe1, 0x0b, 0x59, 0x4f, 0x09, 0xe2, 0x6a, 0x7e, 0x90, 0x2e, 0xcb, 0xd0, 0x60, 0x06, 0x91,
};

uchar	ccp64aad[] = {
	0x87, 0xe2, 0x29, 0xd4, 0x50, 0x08, 0x45, 0xa0, 0x79, 0xc0,
};
uchar	ccp64key[] = {
	0x42, 0x90, 0xbc, 0xb1, 0x54, 0x17, 0x35, 0x31, 0xf3, 0x14, 0xaf, 0x57, 0xf3, 0xbe, 0x3b, 0x50,
	0x06, 0xda, 0x37, 0x1e, 0xce, 0x27, 0x2a, 0xfa, 0x1b, 0x5d, 0xbd, 0xd1, 0x10, 0x0a, 0x10, 0x07,
};
uchar	ccp64iv[] = {
	0xcd, 0x7c, 0xf6, 0x7b, 0xe3, 0x9c, 0x79, 0x4a,
};
uchar	ccp64inp[] = {
	0x86, 0xd0, 0x99, 0x74, 0x84, 0x0b, 0xde, 0xd2, 0xa5, 0xca, 
};
uchar	ccp64out[] = {
	0xe3, 0xe4, 0x46, 0xf7, 0xed, 0xe9, 0xa1, 0x9b, 0x62, 0xa4,
};
uchar	ccp64tag[] = {
	0x67, 0x7d, 0xab, 0xf4, 0xe3, 0xd2, 0x4b, 0x87, 0x6b, 0xb2, 0x84, 0x75, 0x38, 0x96, 0xe1, 0xd6,
};

void
main(int argc, char **argv)
{
	Chachastate s;
	uchar tag[16];
	int n;

	ARGBEGIN{
	}ARGEND
	print("rfc7539:\n");
	print("key:\n");
	printblock(rfckey, sizeof(rfckey));
	n = strlen(rfctext);
	setupChachastate(&s, rfckey, sizeof(rfckey), rfcnonce, sizeof(rfcnonce), 0);
	chacha_setblock(&s, rfccount);
	print("rfc in:\n");
	printblock((uchar*)rfctext, n);
	chacha_encrypt2((uchar*)rfctext, rfcout, n, &s);
	print("rfc out:\n");
	printblock(rfcout, n);
	if(memcmp(rfcout, rfcref, sizeof(rfcref)) != 0){
		print("failure of vision\n");
		exits("wrong");
	}
	print("\n");


	print("xchacha key:\n");
	printblock(xcckey, sizeof(xcckey));

	print("xchacha iv:\n");
	printblock(xcciv, sizeof(xcciv));

	setupChachastate(&s, xcckey, sizeof(xcckey), xcciv, sizeof(xcciv), 20);
	memset(rfcout, 0, sizeof(xccref));
	chacha_encrypt(rfcout, sizeof(xccref), &s);

	print("xchacha out:\n");
	printblock(rfcout, sizeof(xccref));
	if(memcmp(rfcout, xccref, sizeof(xccref)) != 0){
		print("failure of vision\n");
		exits("wrong");
	}
	print("\n");


	print("ccpoly key:\n");
	printblock(ccpkey, sizeof(ccpkey));

	print("ccpoly iv:\n");
	printblock(ccpiv, sizeof(ccpiv));

	setupChachastate(&s, ccpkey, sizeof(ccpkey), ccpiv, sizeof(ccpiv), 20);

	memmove(rfcout, rfctext, sizeof(rfctext)-1);
	ccpoly_encrypt(rfcout, sizeof(rfctext)-1, ccpaad, sizeof(ccpaad), tag, &s);

	print("ccpoly cipher:\n");
	printblock(rfcout, sizeof(rfctext)-1);

	print("ccpoly tag:\n");
	printblock(tag, sizeof(tag));

	if(memcmp(tag, ccptag, sizeof(tag)) != 0){
		print("bad ccpoly tag\n");
		exits("wrong");
	}

	if(ccpoly_decrypt(rfcout, sizeof(rfctext)-1, ccpaad, sizeof(ccpaad), tag, &s) != 0){
		print("ccpoly decryption failed\n");
		exits("wrong");
	}

	if(memcmp(rfcout, rfctext, sizeof(rfctext)-1) != 0){
		print("ccpoly bad decryption\n");
		exits("wrong");
	}
	print("\n");


	print("ccpoly64 key:\n");
	printblock(ccp64key, sizeof(ccp64key));

	print("ccpoly64 iv:\n");
	printblock(ccp64iv, sizeof(ccp64iv));

	setupChachastate(&s, ccp64key, sizeof(ccp64key), ccp64iv, sizeof(ccp64iv), 20);

	memmove(rfcout, ccp64inp, sizeof(ccp64inp));
	ccpoly_encrypt(rfcout, sizeof(ccp64inp), ccp64aad, sizeof(ccp64aad), tag, &s);

	print("ccpoly64 cipher:\n");
	printblock(rfcout, sizeof(ccp64inp));

	print("ccpoly64 tag:\n");
	printblock(tag, sizeof(tag));

	if(memcmp(rfcout, ccp64out, sizeof(ccp64out)) != 0){
		print("ccpoly64 bad ciphertext\n");
		exits("wrong");
	}
	if(memcmp(tag, ccp64tag, sizeof(ccp64tag)) != 0){
		print("ccpoly64 bad encryption tag\n");
		exits("wrong");
	}

	if(ccpoly_decrypt(rfcout, sizeof(ccp64inp), ccp64aad, sizeof(ccp64aad), tag, &s) != 0){
		print("ccpoly64 decryption failed\n");
		exits("wrong");
	}
	if(memcmp(rfcout, ccp64inp, sizeof(ccp64inp)) != 0){
		print("ccpoly64 bad decryption\n");
		exits("wrong");
	}

	print("passed\n");
	exits(nil);
}
