.TH XMLPULL 2
.SH NAME
open_xmlpull,
next_xmlpull,
free_xmlpull \- XML-Pull parser functions
.SH SYNOPSIS
.PP
.EX
.ta 4n +4n +4n +4n
#include <u.h>
#include <xmlpull.h>
.sp
enum { 
	START_DOCUMENT = 0x0,
	START_TAG,
	START_END_TAG,
	TEXT,
	TEXT_C,
	ATTR,
	END_TAG,
	END_TAG_S,
	END_TAG_N,
	END_DOCUMENT,
};
.sp
.ta \w'    'u +\w'xmlpull 'u
typedef struct xmlpull xmlpull;
struct xmlpull {
	int fd;
	char ev;
	char nev;
	char *lm;
	char *na;
	char *va;
	int la;
	int lv;
	int ln;
};
.fi
.de XX
.ift .sp 0.5
.ifn .sp
..
.PP
.nf
.ft L
.ta \w'\fLxmlpull* 'u +4n +4n +4n +4n
void freexmlpull(xmlpull *x);
xmlpull *openxmlpull(int fd);
xmlpull *nextxmlpull(xmlpull *x);
xmlpull *writexmlpull(xmlpull *x);
.EE
.SH DESCRIPTION
.PP
Libxmlpull is a library for parsing and writing XML-files. The parsing is
done in the way described on http://www.xmlpull.org, in a more simple way.
On the other side the writing does do XML-pull in the oder direction.
.PP
A parsing session is started by calling
.IR openxmlpull
, with a filedescriptor from which is read until it is manually closed.
It returns the structure xmlpull, holding the state of the actual
session.
.PP
Next the function 
.IR nextxmlpull
is constantly called and gives back the
next event found in the read data.
.IR nextxmlpull
returns the changed xmlpull structure with the actual
read event.
.PP
The actual event is saved in xmlpull->ev, the name of the element or
attribute in xmlpull->na and its length in xmlpull->ln. When the event
has the value ATTR, xmlpull->va holds the data of the value of the
attribute and xmlpull->lv its length. The events START_DOCUMENT and
END_DOCUMENT do not have any values. END_TAG_S and END_TAG_N are only
used by
.IR write_elem .
.PP
Writing is done by opening a session with 
.IR openxmlpull
and then doing a 
.IR writexmlpull
in the other direction like
.IR nextxmlpull .
.PP
When the session is finished, all allocated memory can be freed by calling
.IR freexmlpull .
.PP
.SH FILES
.PP
.B test_read.c (mkfile.read)
example for reading an XML-file..
.B test_write.c (mkfile.write)
example for writing an XML-file.
.SH SOURCE
.B http://www.r-36.net/xmlpull.tgz
