/*
 * Copy me if you can.
 * by 20h
 */

#ifndef PLAN9
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#endif
#ifdef PLAN9
#include <u.h>
#include <libc.h>
#endif
#include "xmlpull.h"

int
main(int argc, char *argv[])
{
	xmlpull *ret;
	int fd;

	if(argc < 2){
		print("usage: filename\n");
		exits(0);
	}

	fd = open(argv[1],
#ifndef PLAN9
			O_WRONLY);
#endif
#ifdef PLAN9
			OWRITE);
#endif
	if(fd < 0){
		perror("open");
		exits(0);
	}

	ret = openxmlpull(fd);

	ret->nev = START_DOCUMENT;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = START_TAG;
	ret->na = "message";
	ret->ln = 7;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = ATTR;
	ret->na = "to";
	ret->ln = 2;
	ret->va = "user";
	ret->lv = 4;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = ATTR;
	ret->na = "from";
	ret->ln = 4;
	ret->va = "programmer";
	ret->lv = 10;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = END_TAG_N;
	if(writexmlpull(ret) == nil)
		goto end_main;

	if(write(ret->fd, "\n", 1) < 0)
		goto end_main;

	ret->nev = START_TAG;
	ret->na = "value";
	ret->ln = 5;
	if(writexmlpull(ret) == nil)
		goto end_main;

	if(write(ret->fd, "\n", 1) < 0)
		goto end_main;

	ret->nev = END_TAG_N;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = START_TAG;
	ret->na = "!--";
	ret->ln = 3;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = TEXT_C;
	ret->na = "Here comes the message.";
	ret->ln = 23;
	if(writexmlpull(ret) == nil)
		goto end_main;

	if(write(ret->fd, "\n", 1) < 0)
		goto end_main;

	ret->nev = TEXT;
	ret->na = "Thank you for using Libxmlpull.\n";
	ret->ln = 32;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = END_TAG;
	ret->na = "value";
	ret->ln = 5;
	if(writexmlpull(ret) == nil)
		goto end_main;

	if(write(ret->fd, "\n", 1) < 0)
		goto end_main;

	ret->nev = START_TAG;
	ret->na = "attachments";
	ret->ln = 11;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = ATTR;
	ret->na = "num";
	ret->ln = 3;
	ret->va = "0";
	ret->lv = 1;
	if(writexmlpull(ret) == nil)
		goto end_main;

	ret->nev = END_TAG_S;
	if(writexmlpull(ret) == nil)
		goto end_main;

	if(write(ret->fd, "\n", 1) < 0)
		goto end_main;

	ret->nev = END_TAG;
	ret->na = "message";
	ret->ln = 7;
	if(writexmlpull(ret) == nil)
		goto end_main;

	if(write(ret->fd, "\n", 1) < 0)
		goto end_main;

	ret->nev = END_DOCUMENT;
	if(writexmlpull(ret) == nil)
		goto end_main;

end_main:
	free(ret);
	exits(0);
}
