/*
 * Copy me if you can.
 * by 20h
 */

#ifndef PLAN9
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#endif
#ifdef PLAN9
#include <u.h>
#include <libc.h>
#endif
#include "xmlpull.h"

void
main(int argc, char *argv[])
{
	xmlpull *ret, *b;
	int fd;

	if(argc < 2){
		print("usage: filename\n");
		exits(0);
	}

	fd = open(argv[1],
#ifndef PLAN9
			O_RDONLY);
#endif
#ifdef PLAN9
			OREAD);
#endif
	if(fd < 0){
		perror("open");
		exits(0);
	}

	ret = openxmlpull(fd);
	while((b = nextxmlpull(ret)) != nil){
		switch(b->ev){
		case START_DOCUMENT:
			print("Document started.\n");
			break;
		case START_TAG:
			print("Tag starts: %s\n", b->na);
			break;
		case START_END_TAG:
			print("Startend tag: %s\n", b->na);
			break;
		case TEXT:
			print("Text: %s\n", b->na);
			break;
		case ATTR:
			print("Attr: %s=%s\n", b->na, (b->va == nil) ? "none" : b->va);
			break;
		case END_TAG:
			print("Tag ends: %s\n", b->na);
			break;
		case END_DOCUMENT:
			print("Document ends.\n");
			break;
		default:
			print("Undocumented: %x\n", b->ev);
			break;
		}
	}
	
	freexmlpull(ret);
	exits(0);
}


	
