#include <u.h>
#include <libc.h>
#include <bio.h>
#include <ctype.h>
#include <mp.h>
#include <libsec.h>
#include <auth.h>
#include <thread.h>

typedef struct Conn Conn;
typedef struct ConnHalf ConnHalf;
typedef struct Msg Msg;

struct ConnHalf
{
	Conn *c;
	int fd;
	int (*mac)(ConnHalf*, Msg*, uchar*);
	int maclen;
	int (*crypt)(ConnHalf*, Msg*);
	Msg *(*compress)(ConnHalf*, Msg*);
};

struct Conn
{
	char	*localversion;
	char *remoteversion;

	ConnHalf in;
	ConnHalf out;
};

struct Msg
{
	Conn *c;
	int type;
	
	uchar *bp;
	uchar *ep;
};

enum
{
	MaxPacketLen = 65536,
};

Conn*	mkconn(int rfd, int wfd);
int		protoexchange(Conn*);


void*	emalloc(int);
void*	emallocnz(int);
char*	estrdup(char*);
int		msgfmt(Fmt*);

Msg*	msgalloc(Conn*, uint);
void		msgfree(Msg*);
Msg*	connread(Conn*);

#define _G32(p)	(p[3] | (p[2]<<8) | (p[1]<<16) | (p[0]<<24))
#define G32(p)	_G32((p))

