#include "ssh.h"

static char *host;

void
usage(void)
{
	fprint(2, "usage: ssh host\n");
	threadexitsall("usage");
}

void
threadmain(int argc, char **argv)
{
	int fd;
	Conn *z;
	Msg *m;
	
	quotefmtinstall();
	fmtinstall('H', encodefmt);
	fmtinstall('M', msgfmt);

	ARGBEGIN{
	default:
		usage();
	}ARGEND
	
	if(argc != 1)
		usage();

	host = netmkaddr(argv[0], "net", "ssh");
	if((fd = dial(host, nil, nil, nil)) < 0)
		sysfatal("dial %s: %r", host);

	z = mkconn(fd, fd);
	z->localversion = estrdup("SSH-2.0-Plan9 Memorial Day");
	if(protoexchange(z) < 0)
		sysfatal("protocol exchange: %r");
	
	fprint(2, "local %q remote %q\n", z->localversion, z->remoteversion);
	
	while((m = connread(z)) != nil)
		print("msg %M\n", m);
	sysfatal("connread: %r");

	threadexitsall(nil);
}

