#include "ssh.h"

/*
   When the connection has been established, both sides MUST send an



Ylonen, et. al.          Expires March 21, 2003                 [Page 3]

Internet-Draft        SSH Transport Layer Protocol        September 2002


   identification string of the form "SSH-protoversion-softwareversion
   comments", followed by carriage return and newline characters (ASCII
   13 and 10, respectively).  Both sides MUST be able to process
   identification strings without carriage return character.  No null
   character is sent.  The maximum length of the string is 255
   characters, including the carriage return and newline.

   The part of the identification string preceding carriage return and
   newline is used in the Diffie-Hellman key exchange (see Section
   Section 6).

   The server MAY send other lines of data before sending the version
   string.  Each line SHOULD be terminated by a carriage return and
   newline.  Such lines MUST NOT begin with "SSH-", and SHOULD be
   encoded in ISO-10646 UTF-8 [RFC2279] (language is not specified).
   Clients MUST be able to process such lines; they MAY be silently
   ignored, or MAY be displayed to the client user; if they are
   displayed, control character filtering discussed in [SSH-ARCH] SHOULD
   be used.  The primary use of this feature is to allow TCP-wrappers to
   display an error message before disconnecting.

   Version strings MUST consist of printable US-ASCII characters, not
   including whitespaces or a minus sign (-).  The version string is
   primarily used to trigger compatibility extensions and to indicate
   the capabilities of an implementation.  The comment string should
   contain additional information that might be useful in solving user
   problems.

   The protocol version described in this document is 2.0.

   Key exchange will begin immediately after sending this identifier.
   All packets following the identification string SHALL use the binary
   packet protocol, to be described below.

3.3 Compatibility With Old SSH Versions

   During the transition period, it is important to be able to work in a
   way that is compatible with the installed SSH clients and servers
   that use an older version of the protocol.  Information in this
   section is only relevant for implementations supporting compatibility
   with SSH versions 1.x.

3.4 Old Client, New Server

   Server implementations MAY support a configurable "compatibility"
   flag that enables compatibility with old versions.  When this flag is
   on, the server SHOULD identify its protocol version as "1.99".
   Clients using protocol 2.0 MUST be able to identify this as identical



Ylonen, et. al.          Expires March 21, 2003                 [Page 4]

Internet-Draft        SSH Transport Layer Protocol        September 2002


   to "2.0".  In this mode the server SHOULD NOT send the carriage
   return character (ASCII 13) after the version identification string.

   In the compatibility mode the server SHOULD NOT send any further data
   after its initialization string until it has received an
   identification string from the client.  The server can then determine
   whether the client is using an old protocol, and can revert to the
   old protocol if required.  In the compatibility mode, the server MUST
   NOT send additional data before the version string.

   When compatibility with old clients is not needed, the server MAY
   send its initial key exchange data immediately after the
   identification string.

3.5 New Client, Old Server

   Since the new client MAY immediately send additional data after its
   identification string (before receiving server's identification), the
   old protocol may already have been corrupted when the client learns
   that the server is old.  When this happens, the client SHOULD close
   the connection to the server, and reconnect using the old protocol.
*/

int
protoexchange(Conn *z)
{
	char buf[256];
	int nbuf, n, bol;
	
	/*
	 * Sometimes we're supposed to send a CR,
	 * sometimes not.  No matter what, the remote
	 * side isn't supposed to care.  So no CRs.
	 */
	if(fprint(z->out.fd, "%s\n", z->localversion) < 0)
		return -1;

	bol = 1;	/* at beginning of line */
Again:
	nbuf = 0;
	do{
		if((n=read(z->in.fd, buf+nbuf, 1)) == 0){
			werrstr("unexpected eof");
			return -1;
		}
		if(n < 0)
			return -1;
	}while(++nbuf<sizeof buf-1 && buf[nbuf-1]!='\n');

	/*
	 * Remote can send lines not beginning with SSH-
	 * which must be ignored (or displayed).
	 */
	buf[nbuf] = 0;
	if(!bol || memcmp(buf, "SSH-", 4) != 0){
		/*
		 * extra line at beginning.  XXX print
		 */
		bol = buf[nbuf-1] == '\n';
		goto Again;
	}

	if(buf[nbuf-1] != '\n'){
		buf[nbuf] = 0;
		werrstr("remote version too long: %.*s", 
			utfnlen(buf, nbuf), buf);
		return -1;
	}
	
	buf[--nbuf] = 0;
	if(buf[nbuf-1] == '\r')
		buf[--nbuf] = 0;

	z->remoteversion = estrdup(buf);

	return 0;
}
