#include <sys/param.h>
#include <ctype.h>
#include <errno.h>
#include <pwd.h>
#include <termios.h>
#include "dat.h"
#include "fns.h"

struct Tty {
	int		fd;
	int		raw;
	struct termios	term;
};

int
sshisatty(int fd)
{
	return isatty(fd);
}

Tty*
sshgettty(int fd)
{
	Tty *tty;

	tty = emalloc(sizeof *tty);
	tty->fd = fd;
	return tty;
}

void
sshfreetty(Tty *tty)
{
	free(tty);
}

void
sshrawon(Tty *tty)
{
	struct termios t;

	if(tty->raw)
		return;
	if(tcgetattr(tty->fd, &tty->term) < 0)
		panic("sshrawon: tcgetattr %r (%lux)", getcallerpc(&tty));
	t = tty->term;

 Again:
	if(tcsetattr(tty->fd, TCSADRAIN, &t) < 0){
		if(errno == EINTR)
			goto Again;
		panic("sshrawon: tcsetattr %r (%lux)", getcallerpc(&tty));
	}
	tty->raw = 1;
	return;
}

void
sshrawoff(Tty *tty)
{
	if(tty->raw == 0)
		return;
 Again:
	if(tcsetattr(tty->fd, TCSADRAIN, &tty->term) < 0){
		if(errno == EINTR)
			goto Again;
		panic("sshrawoff: tcsetattr %r (%lux)", getcallerpc(&tty));
	}
	tty->raw = 0;
	return;
}

char*
sysgetuser(void)
{
	char *s;
	struct passwd *pw;

	pw = getpwuid(getuid());
	s = estrdup(pw->pw_name);
	memset(pw->pw_passwd, 0, strlen(pw->pw_passwd));

	return s;
}

char*
sysgetpass(char *prompt)
{
	int n;
	char *p, *s, *t;

	n = strlen(prompt);
	p = estrdup(prompt);
	if(n > 0 && isspace(prompt[n-1]) == 0)
		p = estrcat(p, " ");
	s = getpass(p);
	free(p);
	t = estrdup(s);
	memset(s, 0, strlen(s));

	return t;
}

char*
syshome(void)
{
	struct passwd *pw;
	static char buf[MAXPATHLEN+1];

	pw = getpwuid(getuid());
	if(pw == nil)
		return "/";
	memset(buf, 0, sizeof buf);
	strncpy(buf, pw->pw_dir, sizeof buf);
	memset(pw->pw_passwd, 0, strlen(pw->pw_passwd));
	return buf;
}

char*
syscfgdir(void)
{
	return "etc/ssh";
}

long
writen(int f, void *av, long n)
{
	char *a;
	long m, t;

	a = av;
	t = 0;
	while(t < n){
		m = write(f, a+t, n-t);
		if(m <= 0){
			if (errno == EINTR)
				continue;
			break;
		}
		t += m;
	}

	return t;
}
