#include "dat.h"
#include "fns.h"

char	*dbgname = "ssh";
int	mainstacksize = 1<<16;

static void
usage(void)
{
	fprint(2, "usage: ssh [-AVsv?] [-D [dbgstr]] [-C cfg] host\n");
	threadexitsall("usage");
}

void
threadmain(int argc, char *argv[])
{
	int rv, fd[2];
	char *cfgname;
	char *s, *user, *host, *addr;

	Conn *c;
	Channel *rc, *wc;

	installfmts();
	installcleanup();

	user = nil;
	host = nil;
	cfgname = esmprint("%s/%s/ssh.cfg", syshome(), syscfgdir());

//	mainmem->flags |= POOL_ANTAGONISM;

	ARGBEGIN{
	case 'A':
		doabort = 1;
		break;

	case 'C':
		cfgname = EARGF(usage());
		break;

	case 'D':
		dbglevel++;
		s = ARGF();
		if(s != nil)
			dbglevel = debugparse(s);
		break;

	case 'V':
		print("release: %s\n", release());
		threadexitsall(nil);
		break;

	case 'c':
		sysfatal("-c (compress) not implemented");
		break;

	case 'l':
	case 'u':
		user = EARGF(usage());
		break;

	case 's':
		strict = 1;
		break;

	case 'v':
		verbose++;
		break;

	case 'h':
	case '?':
	default:
		usage();
		break;
	}ARGEND;

	if(argc != 1)
		usage();

	host = estrdup(argv[0]);
	if(user == nil){
		s = strchr(host, '@');
		if(s != nil){
			*s = '\0';
			user = estrdup(host);
			s = estrdup(s+1);
			free(host);
			host = s;
		}else
			user = sysgetuser();
	}

	/* XXX: set $home for mkcfg */
	c = mkconn(RClient, user, host, cfgname);
	if(c == nil)
		sysfatal("can't configure client: %r");

	addr = netmkaddr(host, "tcp", "ssh");
	fd[1] = fd[0] = dial(addr, nil, nil, nil);
	if(fd[0] < 0)
		sysfatal("can't dial %s: %r", addr);

	connsetfd(c, fd);
	rc = chancreate(sizeof(void*), 0);
	wc = chancreate(sizeof(void*), 0);

	serviceinit(c);
	xportinit(c, rc, wc);
	authinit(c);
	rv = authclient(c, rc, wc, "ssh-connection");
	if(rv < 0)
		sysfatal("authentication fails: %r");

	threadexits(nil);
}
