#include "dat.h"
#include "fns.h"

static	void	setbugflags(Conn*, char*);

static	char	version[] = "SSH-2.0-Plan9_1.0 Ma Bell";

void
sshnop(Conn *c, Channel *wc, int n)
{
	Msg *m;

	/* XXX: random padding/data */
	debug(DbgProto, "sshnop: sending SSH_MSG_IGNORE %d", n);
	m = allocmsg(c, SSH_MSG_IGNORE, 0);
	putlong(&m->b, 1);
	putbyte(&m->b, n);
	sendmsg(wc, m);

	return;
}

void
sshdebug(Conn *c, Channel *wc, char *msg)
{
	Msg *m;

	if(c->bugflags & BugNoDebug){
		debug(DbgProto, "sshdebug: no remote support");
		return;
	}

	debug(DbgProto, "sshdebug: sending SSH_MSG_DEBUG '%s'", msg);
	m = allocmsg(c, SSH_MSG_DEBUG, 0);
	putbool(&m->b, 1);			/* always dislay */
	putstring(&m->b, msg);			/* message */
	putstring(&m->b, "");			/* language tag (wtf?) */
	sendmsg(wc, m);

	return;
}

int
sendversion(Conn *c)
{
	int n;
	char *s;

	if(c->role == RClient)
		c->cversion = estrdup(version);
	else
		c->sversion = estrdup(version);
	s = esmprint("%s\r\n", version);
	n = strlen(s);
	if(writen(c->fd[1], s, n) != n){
		werrstr("short net write: %r");
		free(s);
		return -1;
	}
	debug(DbgPacket, "local version: %s", version);
	free(s);
	return 0;
}

static int readverln(int, char*, int);

int
recvversion(Conn *c)
{
	int m, n;
	char *p, *q;
	char buf[255+1];

	while((n = readverln(c->fd[0], buf, sizeof(buf)-1)) >= 0){
		if(n <= 4)
			continue;
		if(strncmp(buf, "SSH-", 4) == 0)
			break;
	}
	if(n < 0)
		return -1;

	debug(DbgPacket, "remote version: %s", filterstring(buf));

	/* SSH-m.n-software comment */
	n = strtol(buf+4, &p, 10);
	if(p == buf || *p != '.' || (n != 1 && n != 2))
		goto Badver;
	m = strtol(p+1, &q, 10);
	if(q == p+1 || *q != '-' || (n == 1 && m != 99) || (n == 2 && m != 0))
		goto Badver;

	setbugflags(c, ++q);	/* bug-for-bug compatibility */

	if(c->role == RClient)
		c->sversion = estrdup(buf);
	else
		c->cversion = estrdup(buf);
	c->wirestate = WSraw;
	return 0;

 Badver:
	filterstring(buf);
	panic("protocol mismatch; got %s, need SSH-1.99 or SSH-2.0", buf);
	return -1;	/* gcc */
}

int
snarfc(int fd)
{
	int c = 0;

	switch(read(fd, &c, 1)){
	default:
		return -1;

	case 0:
		werrstr("unexpected EOF");
		return -1;

	case 1:
		return c;
	}

	panic(Ebotch);
}

static int
readverln(int fd, char *buf, int nbuf)
{
	int i, c;

	for(i=0; i<nbuf; i++){
		if((c = snarfc(fd)) < 0){
			return -1;
		}
		if(c == '\r' || c == '\n'){
			buf[i] = '\0';
			debug(DbgPacket,"version line: %s", filterstring(buf));
			return i;
		}
		buf[i] = c;
	}
	buf[i] = '\0';

	debug(DbgPacket, "version line: %s", filterstring(buf));

	do{
		if((c = snarfc(fd)) < 0)
			return -1;
	}while(c != '\n');

	return 0;
}

/*
 * This table is known to be incomplete
 * There are also some bugs which we do not wish to support
 */
static struct {
	char	*glob;
	u32int	flags;
} bugtab[] = {
	{ "OpenSSH-2.'[01]'*",		BugNoReKey|BugOldGpExchange },
	{ "OpenSSH_2.'[12]'*",		BugNoReKey|BugOldGpExchange },
	{ "OpenSSH_2.3.0'*",		BugNoReKey|BugOldGpExchange },
	{ "OpenSSH_2.5.'[01]p1'*",	BugNoReKey|BugOldGpExchange },
	{ "OpenSSH_2.5.'[012]'*",	BugNoReKey|BugOldGpExchange },
	{ "Sun_SSH_1.0'*",		BugNoReKey },
	{ "OpenSSH'*",			0 },
	{ "2.1.0'*",			BugNoDebug|BugFirstKex },
	{ "2.1 '*",			BugNoDebug|BugFirstKex },
	{ "2.0.1'[3-9]'*",		BugNoDebug|BugFirstKex },
	{ "2.0.1'[12]'*",		BugNoDebug|BugFirstKex },
	{ "2.0.'*",			BugNoDebug|BugFirstKex },
	{ "2.'[23].0'*",		BugNoDebug|BugFirstKex },
	{ "2.4",			0 },
	{ "2.'*",			BugNoDebug|BugFirstKex },
	{ "3.0.'*",			BugNoDebug },
	{ "3.0 SecureCRT'*",		0 },
	{ "1.7 SecureFX'*",		0 },
	{ "1.2.1'[89]'*",		0 },
	{ "1.2.2'[012]'*",		0 },
	{ "1.3.2'*",			0 },	/* F-Secure */
	{ "1.2.'[1-3]'*",		0 },
	{ "'*SSH_Version_Mapper'*",	0 },
	{ "Probe-'*",			0 },
	{ nil, 0 }
};

static void
setbugflags(Conn *c, char *vs)
{
	int i;

	debug(DbgProto, "setbugflags: %s", vs);
	for(i=0; bugtab[i].glob != nil; i++)
		if(match(vs, bugtab[i].glob)){
			debug(DbgProto, "bugflags: glob: \"%s\"\tflags: 0x%ux",
			      bugtab[i].glob, bugtab[i].flags);
			c->bugflags = bugtab[i].flags;
			break;
		}

	return;
}
