#include "dat.h"
#include "fns.h"

static Kex* kextab[] = {
	&kexdhgex,
	&kexdh
};

static Auth* authtab[] = {
	&authpublickey,
	&authkbdinteractive,
	&authpassword
};

static Authsrv* authsrvtab[] = {
	nil,
//	&authsrvpassword,
//	&authsrvpublickey,
//	&authsrvkbdinteractive
};

static CertImpl* certtab[] = {
	&certsshdss,
	&certsshrsa
};

static SigImpl* sigtab[] = {
	&sigsshdss,
	&sigsshrsa
};

static Cipher* ciphertab[] = {
	&cipheraes128,
	&cipheraes192,
	&cipheraes256,
	&cipherblowfish,
	&cipher3des,
	&cipherdes,			/* XXX: turn des off */
	&cipherrc4,			/* XXX: turn rc4 off */
	&ciphernone			/* XXX: turn none off */
};

static Digest* digesttab[] = {
	&digestsha1,
	&digestmd5
};

static Hmac* hmactab[] = {
	&hmacsha1,
	&hmacmd5
};

static struct {
	char		*name;
	int		nitab;
	Impl 		**itab;
} impltab[] = {
	{ "kex", nelem(kextab), (Impl**)kextab },
	{ "auth", nelem(authtab), (Impl**)authtab },
	{ "authsrv", nelem(authsrvtab), (Impl**)authsrvtab },
	{ "cert", nelem(certtab), (Impl**)certtab },
	{ "sig", nelem(sigtab), (Impl**)sigtab },
	{ "cipher", nelem(ciphertab), (Impl**)ciphertab },
	{ "digest", nelem(digesttab), (Impl**)digesttab },
	{ "hmac", nelem(hmactab), (Impl**)hmactab },
};

Impllist*
loadimpl(Conn *c, char *name, Namelist *nl)
{
	int i, j;
	int nitab;
	Impl **itab;
	Impllist *p;

	USED(c);

	nitab = 0;
	itab = nil;
	for(i=0; i < nelem(impltab); i++)
		if(strcmp(impltab[i].name, name) == 0){
			nitab = impltab[i].nitab;
			itab = impltab[i].itab;
			break;
		}
	if(i == nelem(impltab))
		panic("bad implementation: '%s'", name);

	p = mkimpllist();
	if(nl == nil){
		for(i=0; i<nitab; i++)
			appendimpl(p, itab[i]);
	}else{
		/* use ordering imposed by the list of names */
		for(i=0; i<nl->nstr; i++)
			for(j=0; j<nitab; j++)
				if(strcmp(nl->strtab[i], itab[j]->name) == 0)
					appendimpl(p, itab[j]);
	}

	if(p->nimpl == 0){
		freeimpllist(p);
		p = nil;
	}

	return p;
}
