#include "dat.h"
#include "fns.h"

Impl*
findimpl(Impllist *il, char *nm)
{
	int i;

	if(il == nil)
		return nil;

	for(i=0; i<il->nimpl; i++)
		if(strcmp(il->impl[i]->name, nm) == 0)
			return il->impl[i];
	return nil;
}

void
appendimpl(Impllist *il, Impl *p)
{
	il->impl = erealloc(il->impl, (il->nimpl+1)*sizeof(il->impl[0]));
	il->impl[il->nimpl++] = p;
}

Impllist*
mkimpllist(void)
{
	Impllist *p;

	p = emalloc(sizeof *p);
	return p;
}

void
freeimpllist(Impllist *il)
{
	if(il == nil)
		return;
	free(il->impl);
	free(il);
}

char*
consimpllist(Impllist *il)
{
	int i;
	char *s;

	/* XXX: authsrvtab currently empty */
	if(il->nimpl == 1 && il->impl[0] == nil)
		return estrdup("");

	s = nil;
	for(i=0; i<il->nimpl; i++){
		if(i != 0)
			s = estrcat(s, ",");
		s = estrcat(s, il->impl[i]->name);
	}
	return s;
}

static Namelist*
allocnamelist(char *s, int n)
{
	int m;
	Namelist *p;

	m = strlen(s)+1;
	p = emalloc(sizeof(*p)+m+n*sizeof(char*));
	p->nstr = n;
	p->str = (char*)(p+1);
	p->strtab = (char**)(p->str+m);
	strcpy(p->str, s);

	return p;
}

void
freenamelist(Namelist *p)
{
	if(p == nil)
		return;
	free(p);
}

Namelist*
parsenamelist(char *s)
{
	int n;
	char *t;
	Namelist *p;

	if(s == nil)
		return nil;

	for(n=0, t=s; *t; t++)
		if(*t == ',')
			n++;
	p = allocnamelist(s, n+1);
	n = 0;
	p->strtab[n++] = p->str;
	for(t=p->str; *t; t++)
		if(*t == ','){
			*t = '\0';
			p->strtab[n++] = t+1;
		}
	p->nstr = n;
	return p;
}

/* XXX: assume parsenamelist was used to create p, else we leak */
void
removename(Namelist *p, char *s)
{
	char **q;
	int i, n;

	for(i=0; i<p->nstr; i++)
		if(strcmp(p->strtab[i], s) == 0){
			p->strtab[i] = nil;
			p->nstr--;
			n = p->nstr - i;
			q = p->strtab+i;
			memmove(q, q+1, n*sizeof(*q));
			break;
		}
	return;
}

Namelist*
impl2name(Impllist *il)
{
	char *s;
	Namelist *nl;

	s = consimpllist(il);
	nl = parsenamelist(s);
	free(s);

	return nl;
}

void
namelistintersect(Namelist *a, Namelist *b)
{
	int i, j;

	assert(a != nil);

	for(i=0; i<a->nstr; i++){
		for(j=0; b && j<b->nstr; j++)
			if(strcmp(a->strtab[i], b->strtab[j]) == 0)
				break;
		if(b == nil || j == b->nstr)
			removename(a, a->strtab[i]);
	}

	return;
}

int
namelistfmt(Fmt *fmt)
{
	int i;
	Namelist *l;

	l = va_arg(fmt->args, Namelist*);
	if(l == nil)
		return fmtstrcpy(fmt, "*");
	for(i=0; i<l->nstr; i++)
		fmtprint(fmt, "%s%s", l->strtab[i], i+1==l->nstr?"":",");
	return 0;
}
