#include "dat.h"
#include "fns.h"

int	verbose;
u32int	dbglevel;
char	*dbgname = "ssh/keyprint";

extern	char	*release(void);

static void
usage(void)
{
	fprint(2, "usage: ssh/keyprint [-AVv?] [-T fpfmt] file\n");
	exits("usage");
}

/* XXX: single threaded program, but I'm lazy */
void
threadmain(int argc, char *argv[])
{
	int i;
	int fpfmt;

	char *dtype;
	char *id, *fp;
	char *s, *fname;

	Biobuf *b;
	Cert *cert;
	Impllist *il;
	Digest *digest;
	
	installfmts();

	b = nil;
	cert = nil;
	digest = nil;
	fpfmt = FPHex;
	dtype = "sha1";

	ARGBEGIN{
	case 'A':
		doabort = 1;
		break;

	case 'D':
		dbglevel++;
		s = ARGF();
		if(s != nil)
			dbglevel = debugparse(s);
		break;

	case 'H':
		dtype = EARGF(usage());
		break;

	case 'T':
		s = EARGF(usage());
		fpfmt = fingerprinttype(s);
		break;

	case 'V':
		print("release: %s\n", release());
		exits(nil);
		break;

	case 'v':
		verbose++;
		break;

	case 'h':
	case '?':
	default:
		usage();
		break;
	}ARGEND;

	switch(argc){
	case 1:
		fname = estrdup(argv[0]);
		b = Bopen(fname, OREAD);
		break;

	case 0:
		fname = estrdup("-");
		b = emalloc(sizeof *b);
		Binit(b, 0, OREAD);
		break;

	default:
		usage();
		break;
	}

	il = loadimpl(nil, "digest", nil);
	for(i=0; i<il->nimpl; i++)
		if(cistrcmp(dtype, il->impl[i]->name) == 0){
			digest = (Digest*)il->impl[i];
			break;
		}
	freeimpllist(il);
	if(digest == nil)
		sysfatal("unknown/unsupported digest algorithm: '%s'", dtype);

	if(Brdcertpub(b, &cert, &id) < 0)
		sysfatal("can't read public key: %r");

	fp = fingerprintcert(cert, fpfmt, digest->digest, digest->digestlen);
	print("%s fingerprint: %s\n", digest->name, fp);
	free(fp);

	threadexitsall(nil);
}
