#include "dat.h"
#include "fns.h"

static char hex[] = "0123456789abcdef";

static char*
printhex(uchar *digest, int sz)
{
	int i;
	char *fp;

	fp = emalloc(3*sz+1);
	for(i=0; i<sz; i++){
		fp[3*i] = hex[digest[i] >> 4];
		fp[3*i+1] = hex[digest[i] & 0xF];
		fp[3*i+2] = ':';
	}
	fp[3*sz-1] = '\0';

	return fp;
}

static char vowels[] = "aeiouy";
static char consonants[] = "bcdfghklmnprstvz";		/* sic */

/* bubble-babble format */
static char*
printbabble(uchar *digest, int sz)
{
	int n;
	unsigned i, j, s, t;
	char *fp;

	j = 0;
	s = 1;
	n = sz/2 + 1;
	fp = emalloc(6*n);
	fp[j++] = 'x';
	for(i=0; i<n; i++){
		if(i+1<n || (sz & 1) != 0){
			t = digest[2*i];
			fp[j++] = vowels[(((t >> 6) & 3) + s) % 6];
			fp[j++] = consonants[(t >> 2) & 15];
			fp[j++] = vowels[((t & 3) + (s/6)) % 6];
			if(i+1 < n){
				t = digest[2*i + 1];
				fp[j++] = consonants[(t >> 4) & 15];
				fp[j++] = '-';
				fp[j++] = consonants[t & 15];
				s = ((s*5) + (7*digest[2*i] + t)) % 36;
			}
		}else{
			/* XXX: bug? (openssh says 16, but that is NUL) */
			fp[j++] = vowels[s % 6];
			fp[j++] = consonants[16];
			fp[j++] = vowels[s / 6];
		}
	}
	fp[j++] = 'x';
	fp[j++] = '\0';

	return fp;
}

char*
fingerprintcert(Cert *p, int fmt, DigestFn fn, int sz)
{
	uchar digest[256];

	if(sz > sizeof(digest))
		panic("digestcert: digest too big");
	memset(digest, 0, sizeof(digest));
	p->digest(p, digest, sz, fn, sz);
	switch(fmt){
	default:
		return esmprint("unknown fingerprint type: %d", fmt);

	case FPBubble:
		return printbabble(digest, sz);

	case FPHex:
		return printhex(digest, sz);
	}
	panic(Ebotch);
}

static struct {
	char	*name;
	int	type;
} fptypetab[] = {
	{ "bubble", FPBubble },
	{ "babble", FPBubble },
	{ "hex", FPHex }
};

int
fingerprinttype(char *s)
{
	int i;

	for(i=0; i<nelem(fptypetab); i++)
		if(cistrstr(fptypetab[i].name, s))
			return fptypetab[i].type;
	return FPNone;
}
