#include "dat.h"
#include "fns.h"

struct HmacState {
	int		first;
	uchar		key[SHA1dlen];
	DigestState	ds;
};

static HmacState*
initsha1(Conn *c, Blob *key)
{
	HmacState *s;

	if(key->wp - key->bp < SHA1dlen)
		panic("inithmacsha1: key too short");

	s = emalloc(sizeof *s);
	s->first = 1;
	memmove(s->key, key->bp, SHA1dlen);

	return s;
}

static void
freesha1(HmacState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
hmacdigestsha1(HmacState *s, uchar *b, int n, uchar *d)
{
	ssh_hmacsha1(b, n, s->key, sizeof(s->key), d, &s->ds, s->first);
	if(d == nil){
		if(s->first != 0)
			s->first = 0;
	}else{
		memset(&s->ds, 0, sizeof(s->ds));
		s->first = 1;
	}
	return;
}

Hmac hmacsha1 = {
	"hmac-sha1",
	SHA1dlen,		/* key size */
	SHA1dlen,		/* hash length */
	initsha1,
	freesha1,
	hmacdigestsha1
};
