#include "dat.h"
#include "fns.h"

struct HmacState {
	int		first;
	uchar		key[MD5dlen];
	DigestState	ds;
};

static HmacState*
initmd5(Conn *c, Blob *key)
{
	HmacState *s;

	if(key->wp - key->bp < MD5dlen)
		panic("inithmacmd5: key too short");

	s = emalloc(sizeof *s);
	s->first = 1;
	memmove(s->key, key->bp, MD5dlen);

	return s;
}

static void
freemd5(HmacState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
hmacdigestmd5(HmacState *s, uchar *b, int n, uchar *d)
{
	ssh_hmacmd5(b, n, s->key, sizeof(s->key), d, &s->ds, s->first);
	if(d == nil){
		if(s->first != 0)
			s->first = 0;
	}else{
		memset(&s->ds, 0, sizeof(s->ds));
		s->first = 1;
	}
	return;
}

Hmac hmacmd5 = {
	"hmac-md5",
	MD5dlen,		/* key size */
	MD5dlen,		/* hash length */
	initmd5,
	freemd5,
	hmacdigestmd5
};
