#include "dat.h"
#include "fns.h"

/* XXX: replace libsec hmac to avoid extra malloc/free (probably premature) */

/* rfc2104 */
static DigestState*
hmac(uchar *p, ulong len, uchar *key, ulong n, uchar *digest, DigestState *s,
	DigestState*(*x)(uchar*, ulong, uchar*, DigestState*), int xlen, int f)
{
	int i;
	uchar pad[65], innerdigest[256];

	if(xlen > sizeof(innerdigest))
		return nil;

	if(n>64)
		return nil;

	/* first time through */
	if(f != 0){
		for(i=0; i<64; i++)
			pad[i] = 0x36;
		pad[64] = 0;
		for(i=0; i<n; i++)
			pad[i] ^= key[i];
		s = (*x)(pad, 64, nil, s);
		if(s == nil)
			return nil;
	}

	s = (*x)(p, len, nil, s);
	if(digest == nil)
		return s;

	/* last time through */
	for(i=0; i<64; i++)
		pad[i] = 0x5c;
	pad[64] = 0;
	for(i=0; i<n; i++)
		pad[i] ^= key[i];
	(*x)(nil, 0, innerdigest, s);
	s = (*x)(pad, 64, nil, nil);
	(*x)(innerdigest, xlen, digest, s);
	return nil;
}

DigestState*
ssh_hmacsha1(uchar *p, ulong len, uchar *key, ulong klen, uchar *digest,
	     DigestState *s, int first)
{
	return hmac(p, len, key, klen, digest, s, sha1, SHA1dlen, first);
}

DigestState*
ssh_hmacmd5(uchar *p, ulong len, uchar *key, ulong klen, uchar *digest,
	    DigestState *s, int first)
{
	return hmac(p, len, key, klen, digest, s, md5, MD5dlen, first);
}
