#include "dat.h"
#include "fns.h"

int	verbose;
u32int	dbglevel;
char	*dbgname = "ssh/groupgen";

static	void	usage(void);
static	void	gengroup(int, int);

/* XXX: single threaded program, but I'm lazy */
void
threadmain(int argc, char *argv[])
{
	char *tmp;
	int i, n;
	int max, min;
	int niter, num, step;

	num = 5;
	max = 4096;
	min = 1024;
	step = 512;
	niter = 18;			/* library default */

	installfmts();

	ARGBEGIN{
	case 'A':
		doabort = 1;
		break;

	case 'D':
		dbglevel++;
		tmp = ARGF();
		if(tmp != nil)
			dbglevel = debugparse(tmp);
		break;

	case 'V':
		print("release: %s\n", release());
		exits(nil);
		break;

	case 'i':
		tmp = EARGF(usage());
		niter = atoi(tmp);
		if(niter < 18 || niter > 100){
			fprint(2, "implausible number "
			       "of iterations: %d\n", niter);
			exits("iterations");
		}
		break;

	case 'n':
		tmp = EARGF(usage());
		num = atoi(tmp);
		if(num < 1 || num > 512){
			fprint(2, "implausible number of groups: %d\n", num);
			exits("groups");
		}
		break;

	case 's':
		tmp = EARGF(usage());
		step = atoi(tmp);
		if(step < 256 || step > 4096 || step > max-min){
			fprint(2, "implausible step size: %d\n", step);
			exits("step");
		}
		break;

	case 'v':
		verbose++;
		break;

	case 'h':
	case '?':
	default:
		usage();
	}ARGEND;

	switch(argc){
	default:
		usage();

	case 2:
		min = atoi(argv[0]);
		argv++;
		/* fall through */

	case 1:
		max = atoi(argv[0]);
	}

	if(max < min)
		sysfatal("?maximum modulus less than minimum");

	print("# Precomputed Diffie-Hellman groups for SSH2 key exchange\n");
	print("# min %d max %d num %d niter %d\n\n", min, max, num, niter);
	for(i=min; i<=max; i += step)
		for(n=0; n<num; n++)
			gengroup(i, niter);
	threadexitsall(nil);
}

static void
gengroup(int bits, int niter)
{
	mpint *p, *g;

	p = mpnew(0);
	g = mpnew(0);

	gensafeprime(p, g, bits, niter);
	print("%d\t%3d\t%B\t%B\n", bits, niter, g, p);

	mpfree(p);
	mpfree(g);
}

static void
usage(void)
{
	fprint(2, "usage: groupgen [-ADVv?] [-i iter] [-n num] [min] max\n");
	exits("usage");
}
