#include "dat.h"
#include "fns.h"

/*
 * Import OpenSSH moduli file
 */

enum {
	MinNiter = 20,
};

int	verbose;
u32int	dbglevel;
char	*dbgname = "ssh/modimport";

extern	char	*release(void);

static	void	usage(void);
static	void	translate(Biobuf*, Biobuf*);

void
threadmain(int argc, char *argv[])
{
	char *s;
	Biobuf *bin;
	Biobuf *bout;

	installfmts();

	bin = nil;
	bout = nil;

	ARGBEGIN{
	case 'A':
		doabort = 1;
		break;

	case 'D':
		dbglevel++;
		s = ARGF();
		if(s != nil)
			dbglevel = debugparse(s);
		break;

	case 'V':
		print("release: %s\n", release());
		exits(nil);
		break;

	case 'v':
		verbose++;
		break;

	case 'h':
	case '?':
	default:
		usage();
		break;
	}ARGEND;

	switch(argc){
	default:
		usage();
		break;

	case 0:
		bin = emalloc(sizeof *bin);
		Binit(bin, 0, OREAD);
		break;

	case 1:
		bin = Bopen(argv[0], OREAD);
		if(bin == nil)
			usage();
		break;
	}

	bout = emalloc(sizeof *bout);
	Binit(bout, 1, OWRITE);

	translate(bin, bout);

	Bterm(bin);
	Bterm(bout);

	threadexitsall(nil);
}

static void
translate(Biobuf *bin, Biobuf *bout)
{
	int n;
	int line;
	int bits;
	int niter;

	char *s;
	char *ep;
	char *f[16];

	mpint *p, *g;

	g = nil;
	p = nil;
	line = 1;

	while((s = snarfline(bin, &line)) != nil){
		n = tokenize(s, f, nelem(f));
		if(n != 7){
			warn("corrupt entry line %d\n", line);
			goto Next;
		}
		n = strtol(f[1], &ep, 0);	/* entry type */
		if(f[1][0] == '\0' || *ep != '\0')
			goto Next;
		if(n != 2)			/* type; 2 --> safe prime */
			goto Next;
		n = strtol(f[2], &ep, 0);	/* tests performed */
		if(f[1][0] == '\0' || *ep != '\0')
			goto Next;
		if(n & 1)			/* composite */
			goto Next;
		if((n & ~2) == 0)		/* no serious tests passed */
			goto Next;
		niter = strtol(f[3], &ep, 0);	/* # of tests */
		if(f[1][0] == '\0' || *ep != '\0')
			goto Next;
		if(niter <= MinNiter)		/* too few tries */
			goto Next;
		bits = strtol(f[4], &ep, 0);
		if(f[1][0] == '\0' || *ep != '\0')
			goto Next;
		if(bits < 1023)			/* too few bits */
			goto Next;
		g = strtomp(f[5], &ep, 16, g);
		if(g == nil || *ep != '\0')
			goto Next;
		p = strtomp(f[6], &ep, 16, p);
		if(p == nil || *ep != '\0')
			goto Next;
		Bprint(bout, "%d\t%3d\t%B\t%B\n", bits, niter, g, p);

 Next:
		free(s);
	}

	mpfree(g);
	mpfree(p);

	Bflush(bout);
	return;
}

static void
usage(void)
{
	fprint(2, "usage: ssh/modimport [-ADVv?] [file]\n");
	exits("usage");
}
