#include "dat.h"
#include "fns.h"

enum {
	Glob		= '\''
};

/*
 * Rc-style glob matching
 *	Glob must be followed by one of *, ?, [, or Glob
 *	GlobGlob matches Glob
 */

static	int	equtf(char*, char*);
static	char	*nextutf(char*);

int
match(char *s, char *p)
{
	Rune r, h, l;
	int mat, negate;

	for(r='\0'; *s && *p; s=nextutf(s), p=nextutf(p)){
		if(*p != Glob){
			if(equtf(p, s) == 0)
				return 0;
		}else{
			switch(*++p){
			case Glob:
				if(*s != Glob)
					return 0;
				break;

			case '?':
				if(*s == '\0')
					return 0;
				break;

			case '*':
				for(;;){
					if(match(s, nextutf(p)))
						return 1;
					if(*s == '\0')
						break;
					s = nextutf(s);
				}
				return 0;

			case '[':
				if(*s == '\0')
					return 0;
				chartorune(&r, s);
				p++;
				mat = 0;
				negate = (*p == '~' || *p == '^');
				while(*p != ']'){
					if(*p == '\0')		/* syntax */
						return 0;
					p += chartorune(&l, p);
					if(*p != '-')
						h = l;
					else{
						p++;
						if(*p == '\0')	/* syntax */
							return 0;
						p += chartorune(&h, p);
						if(h < l){	/* XXX: bug? */
							h ^= l;
							l ^= h;
							h ^= l;
						}
					}
					if(l <= r && r <= h)
						mat = 1;
				}
				if(negate)
					mat = !mat;
				if(mat == 0)
					return 0;
				break;
			}
		}
	}

	return *s == '\0';
}

static char*
nextutf(char *s)
{
	int n;
	Rune r;

	if(*s == '\0')
		return s;
	n = chartorune(&r, s);
	return s+n;
}

static int
equtf(char *s, char *p)
{
	int ns, np;
	Rune rs, rp;

	ns = chartorune(&rs, s);
	np = chartorune(&rp, p);

	if(ns != np)
		return 0;
	if(rs != 0x80 && rs == rp)
		return 1;
	while(ns--)
		if(s[ns] != p[ns])
			return 0;
	return 1;
}
