
#define LONG(p)	(((p)[0]<<24)|((p)[1]<<16)|((p)[2]<<8)|((p)[3]))
#define PLONG(p, l) \
	(((p)[0]=(l)>>24),((p)[1]=(l)>>16),\
	 ((p)[2]=(l)>>8),((p)[3]=(l)))
#define SHORT(p) (((p)[0]<<8)|(p)[1])
#define PSHORT(p,l) \
	(((p)[0]=(l)>>8),((p)[1]=(l)))

/* conn.c */
Conn			*mkconn(int, char*, char*, char*);
void			connsetfd(Conn*, int*);
void			freeconn(Conn*);
int			cfgloadimpl(Conn*, Impllist**, char*);
void			conncleanup(void);

/* alarm.c, transport.c */
void			alarminit(Channel*);
void			xportinit(Conn*, Channel*, Channel*);

/* service.c */
void			serviceinit(Conn*);
int			servicereq(Conn*, Channel*, Channel*, char*);

/* proto.c */
void			sshnop(Conn*, Channel*, int);
void			sshdebug(Conn*, Channel*, char*);

int			sendversion(Conn*);
int			recvversion(Conn*);

/* hmac.c */
DigestState		*ssh_hmacsha1(uchar*, ulong, uchar*, ulong, uchar*,
				     DigestState*, int);
DigestState		*ssh_hmacmd5(uchar*, ulong, uchar*, ulong, uchar*,
				     DigestState*, int);

/* kex.c */
void			kexinit(Conn*, Channel*, Channel*);
int			kexrun(Conn*, Channel*, Channel*, Msg*);
int			kexcertcheck(Conn*, Cert*);

/* cert.c */
CertList		*mkcertlist(Cert*);
void			freecertlist(CertList*);

CertImpl		*certwiresniff(Conn*, Blob*);
SigImpl			*sigwiresniff(Conn*, Blob*);
CertImpl		*certstrsniff(char*);

int			certpublookup(char*, Conn*, char*, char**, Cert**);
CertList		*certprivload(Conn*);

/* auth.c */
void			authinit(Conn*);
int			authclient(Conn*, Channel*, Channel*, char*);
int			authserver(Conn*, Channel*, Channel*);
int			authgeneric(Conn*, Channel*, Channel*, Msg*, int);
Msg			*authrecvmsg(Conn*, Channel*, int);

/* authuser.c */
Msg			*ssh_msg_userauthreq(Conn*, char*, char*);
Msg			*ssh_msg_userauthfailure(Conn*, Namelist*, int);
Msg			*ssh_msg_userauthsuccess(Conn*);

/* key.c */
char			*fingerprintcert(Cert*, int, DigestFn, int);
int			fingerprinttype(char*);

/* keyio.c, dhgroup.c */
int			Brdcertpub(Biobuf*, Cert**, char**);
int			Bwrcertpub(Biobuf*, Cert*, char*);
int			Brdcertpriv(Biobuf*, Cert**, char**);
int			Bwrcertpriv(Biobuf*, Cert*, char*);

DHGroup			*Brddhgroups(Biobuf*, char*);
void			freedhgroup(DHGroup*);

/* cfg.c, cfgunix.c, cfgplan9.c, load.c */
Cfg			*mkcfg(Conn*, char*, int, char*, char*);
void			freecfg(Cfg*);
void			cfgoptions(Conn*);
void			cfgdefault(Conn*, char*, char*);
char			*cfgstr(Conn*, char*);
int			cfgint(Conn*, char*);
int			cfgbool(Conn*, char*);
Namelist		*cfgnamelist(Conn*, char*);

Impllist		*loadimpl(Conn*, char*, Namelist*);

/* blob.c */
Blob			*mkblob(ulong);
Blob			*blobrealloc(Blob*, ulong);
void			freeblob(Blob*);
void			clearblob(Blob*);
Blob			*copyblob(uchar*, ulong);
int			sizeblob(Blob*);

/* list.c */
Impl			*findimpl(Impllist*, char*);
void			appendimpl(Impllist*, Impl*);
Impllist		*mkimpllist(void);
void			freeimpllist(Impllist*);
char			*consimpllist(Impllist*);
void			freenamelist(Namelist*);
Namelist		*parsenamelist(char*);
void			removename(Namelist*, char*);
Namelist		*impl2name(Impllist*);
void			namelistintersect(Namelist*, Namelist*);
int			namelistfmt(Fmt*);

/* msg.c */
void			msgqueue(MsgQueue*, Msg*);
Msg			*msgdequeue(MsgQueue*);
Msg			*allocmsg(Conn*, int, int);
void			freemsg(Msg*);
void			badmsg(Msg*, char*);
Blob			*msgpayload(Msg*);
void			sendmsg(Channel*, Msg*);
Msg			*recvmsg(Channel*, int);
Msg			*readmsg(Conn*, int);
int			writemsg(Msg*);
char			*msgname(Msg*);
char			*disconnectmsg(int);
void			disconnect(Conn*, Channel*, int);

uchar			getbyte(Blob*);
ushort			getshort(Blob*);
int			getbool(Blob*);
ulong			getlong(Blob*);
uvlong			getvlong(Blob*);
void			*getbytes(Blob*, int);
char			*getstring(Blob*);
uchar			*getbstring(Blob*, int*);
Blob			*getblobraw(Blob*, int);
Blob			*getblobstring(Blob*);
Namelist		*getnamelist(Blob*);
mpint			*getmpint(Blob*);
Sig			*getsig(Conn*, Blob*);
Cert			*getcert(Conn*, Blob*);

void			putbyte(Blob*, uchar);
void			putshort(Blob*, ushort);
void			putbool(Blob*, int);
void			putlong(Blob*, ulong);
void			putvlong(Blob*, uvlong);
void			putbytes(Blob*, void*, int);
void			putstring(Blob*, char*);
void			putbstring(Blob*, uchar*, int);
void			putblobraw(Blob*, Blob*);
void			putblobstring(Blob*, Blob*);
void			putnamelist(Blob*, Namelist*);
void			putmpint(Blob*, mpint*);
void			putcert(Blob*, Cert*);
void			putsig(Blob*, Sig*);

int			sizestring(char*);
int			sizeblobstring(Blob*);
int			sizempint(mpint*);
int			sizecert(Cert*);
int			sizesig(Sig*);

/* release.c */
char			*release(void);

/* util.c, glob.c */
void			*emalloc(ulong);
void			*erealloc(void*, ulong);
char			*estrdup(char*);
char			*estrcat(char*, char*);
char			*esmprint(char*, ...);
uint			hash(char*);
char			*skiptext(char*);
char			*skipwhite(char*);
char			*trimwhite(char*);
char			*filterstring(char*);	/* modifies string in situ */
char			*snarfline(Biobuf*, int*);
Biobuf			*Bsafeopen(char*, int);
void			_coverage(char*, int);
void			installfmts(void);
void			installcleanup(void);
void			debug(u32int, char*, ...);
u32int			debugparse(char*);
void			panic(char*, ...);
void			warn(char*, ...);
void			cfgwarn(Conn*, char*, ...);
void			error(Conn*, char*, ...);

mpint			*sha1tomp(uchar*, int);
mpint			*mpnrand(mpint*, mpint*);
void			mpclear(mpint*);
void			rsacrt(RSApriv*);

long			iowriten(Ioproc*, int, void*, long);

int			match(char*, char*);

/* unix.c, plan9.c */
int			sshisatty(int);
Tty			*sshgettty(int);
void			sshfreetty(Tty*);
void			sshrawon(Tty*);
void			sshrawoff(Tty*);
char			*sysgetuser(void);
char			*sysgetpass(char*);
char			*syshome(void);
char			*syscfgdir(void);
long			writen(int, void*, long);
