#include "dat.h"
#include "fns.h"

static	DHGroup		*sortgroups(DHGroup*);
static	DHGroup		*mkdhgroup(char*, char*, char*, char*);

DHGroup*
Brddhgroups(Biobuf *bin, char *fname)
{
	int n, line;
	char *s, *t;
	char *f[16];

	DHGroup **gp, *gpl = nil;

	gp = &gpl;
	line = 1;
	while((s = snarfline(bin, &line)) != nil){
		t = skipwhite(s);
		n = tokenize(t, f, nelem(f));
		if(n != 4){
			warn("%s: line %d: malformatted group entry",
			     fname, line);
			goto Next;
		}
		*gp = mkdhgroup(f[0], f[1], f[2], f[3]);
		if(*gp == nil)
			warn("%s: line %d: corrupt group entry", fname, line);
		else
			gp = &(*gp)->link;
 Next:
		free(s);
	}

	gpl = sortgroups(gpl);

	return gpl;
}

void
freedhgroup(DHGroup *g)
{
	if(g == nil)
		return;
	mpfree(g->g);
	mpfree(g->p);
	free(g);
}

static DHGroup*
mkdhgroup(char *bits, char *niter, char *g, char *p)
{
	char *ep;
	DHGroup *gp;

	gp = emalloc(sizeof *gp);
	gp->bits = strtol(bits, &ep, 0);
	if(*bits == '\0' || *ep != '\0')
		goto Error;
	gp->niter = strtol(niter, &ep, 0);
	if(*niter == '\0' || *ep != '\0')
		goto Error;
	gp->g = strtomp(g, &ep, 0, nil);
	if(gp->g == nil || *g == '\0' || *ep != '\0')
		goto Error;
	gp->p = strtomp(p, &ep, 0, nil);
	if(gp->p == nil || *p == '\0' || *ep != '\0')
		goto Error;

	return gp;

 Error:
	freedhgroup(gp);
	return nil;
}

static	int	gpcmp();

static DHGroup*
sortgroups(DHGroup *dl)
{
	int i, n;
	DHGroup *g, **nl;

	for(n=0, g=dl; g != nil; g=g->link)
		n++;

	nl = emalloc((n+1)*sizeof *nl);

	for(n=0, g=dl; g != nil; g=g->link, n++)
		nl[n] = g;
	qsort(nl, n, sizeof *nl, gpcmp);
	for(i=0; i<n; i++)
		nl[i]->link = nl[i+1];
	g = nl[0];
	free(nl);

	return g;
}

static int
gpcmp(void *va, void *vb)
{
	DHGroup *a, *b;

	a = (DHGroup*)va;
	b = (DHGroup*)vb;

	if(a->bits < b->bits)
		return -1;
	if(a->bits == b->bits)
		return 0;
	return 1;
}
