#include <u.h>
#include <libc.h>
//#include <pool.h>
#include <ctype.h>
#include <thread.h>
#include <mp.h>
//#include <auth.h>
#include <libsec.h>
#include <bio.h>

typedef struct AuthInfo AuthInfo;

typedef struct Cfg Cfg;
typedef struct Conn Conn;
typedef struct Connection Connection;
typedef struct Chan Chan;
typedef struct Blob Blob;
typedef struct Msg Msg;
typedef struct MsgQueue MsgQueue;

typedef struct Impl Impl;
typedef struct Impllist Impllist;
typedef struct Namelist Namelist;
typedef struct Tty Tty;

typedef struct Auth Auth;
typedef struct Authsrv Authsrv;
typedef struct AuthContext AuthContext;
typedef struct Cert Cert;
typedef struct Cert CertImpl;			/* sic */
typedef struct CertState CertState;
typedef struct CertList CertList;
typedef struct Cipher Cipher;
typedef struct CipherState CipherState;
typedef struct DHGroup DHGroup;
typedef struct Digest Digest;
typedef struct Digest DigestImpl;		/* sic */
typedef struct Hmac Hmac;
typedef struct HmacState HmacState;
typedef struct Kex Kex;
typedef struct KexState KexState;
typedef struct Sig Sig;
typedef struct Sig SigImpl;			/* sic */
typedef struct SigState SigState;

typedef DigestState* (*DigestFn)(uchar*, ulong, uchar*, DigestState*);

enum {
	STKSZ	= 1<<14,
};

enum		/* internal debugging flags */
{
	DbgDebug		= 1<<0,		/* debug */
	DbgCrypto		= 1<<1,		/* crypto */
	DbgPacket		= 1<<2,		/* packet */
	DbgAuth			= 1<<3,		/* auth */
	DbgCfg			= 1<<4,		/* configuration */
	DbgProc			= 1<<5,		/* proc */
	DbgProto		= 1<<6,		/* proto */
	DbgIO			= 1<<7,		/* io */
	DbgScp			= 1<<8,		/* scp */
};

/* roles */
enum {
	RClient = 1,
	RServer
};

/* wirestate */
enum {
	WShup	= 0,		/* no connection */
	WSraw,			/* raw connection only */
	WSkex,			/* key exchange complete */
	WSauth			/* authentication complete */
};

/* user authentication protocol results */
enum {
	UAfail 		= 1,	/* failure; full stop */
	UAagain,		/* failure, but worth trying again */
	UApartial,		/* success, but not done */
	UAsuccess		/* success; all done */
};

enum {
	AuthKbdTries	= 3,
	AuthPassTries	= 3,
};

/* algorithm capabilities (sign, encrypt, etc.) */
enum {
	Sign	= 1<<0,
	Encrypt	= 1<<1
};

/* Fingerprint formats -- keep in sync with key.c */
enum {
	FPNone,
	FPBubble,
	FPHex
};

/* Bug-for-bug compatibility flags */
enum {
	BugNoReKey		= 1<<0,
	BugNoDebug		= 1<<1,
	BugOldGpExchange	= 1<<2,
	BugFirstKex		= 1<<3,
};

struct Conn {
	int		fd[2];			/* underlying descriptors */
	Ioproc		*io[2];			/* associated Ioproc's */
	Channel		*keylock[2];		/* NEWKEYS lock */
	Channel		*dislock;		/* DISCONNECT */

	int		role;			/* client or server */
	int		wirestate;
	u32int		seqno[2];		/* pkt sequence numbers */

	Cfg		*cfg;			/* current configuration */
	u32int		bugflags;		/* bug-for-bug compat. */

	Blob		*sessionid;		/* the current session's ID */
	char		*cversion;		/* client version string */
	char		*sversion;		/* server version string */
	char		*host;			/* remote host */
	char		*user;

	Tty		*tty;
//	Biobuf		bstdout;
	Biobuf		bstderr;

	Kex		*kex;			/* chosen kex algorithm */
	KexState	*kexstate;		/* kex algorithm's state */
	Impllist	*okkex;

	Auth		*auth;			/* client auth, client side */
	Impllist	*okauth;
	CertList	*authcerts;

	Authsrv		*authsrv;		/* client auth, server side */
	Impllist	*okauthsrv;

	Namelist	*authlist;		/* auth's that can continue */
	int		nauthcontext;
	AuthContext	**authcontext;

	Cert		*hostcert;		/* host authentication */
	CertImpl	*hostcertimpl;
	Impllist	*okhostcert;

	Sig		*hostsig;		/* host authentication */
	SigImpl		*hostsigimpl;
	Impllist	*okhostsig;

	/* keep the same list of acceptable ciphers & HMACs for both sides */
	Cipher		*cipher[2];
	CipherState	*cipherstate[2];
	Impllist	*okcipher;

	Hmac		*hmac[2];		/* chosen HMACs */
	uchar		*digest[2];		/* temp. space for digest */
	HmacState	*hmacstate[2];
	Impllist	*okhmac;

	/* key exchange state */
	int		kexinit;		/* key exchange sent? */
	Blob		*kexkey;
	Blob		*kexhash;
	Blob		*kexblob[2];		/* Payload from last KEXINIT */

	Hmac		*kexhmac[2];
	Cipher		*kexcipher[2];

	/* message naming (sub-protocols only) */
	char*		(*msgnamekex)(int);
	char*		(*msgnameauth)(int);

	/* for clean up handlers */
	Conn		*link;
};

struct Connection {
	Conn		*c;
	Channel		*ctl;			/* ctl chan */
	Channel		*netr;			/* from wire */
	Channel		*netw;			/* to wire */
	Channel		*disw;			/* for disconnect */
};

struct Chan {
	u32int		id;			/* channel ID */
	u32int		remid;			/* remote channel ID */
	u32int		winsize;		/* window size */
	u32int		winused;		/* bytes used */
	u32int		maxpacket;		/* maximum packet size */
};

struct Blob {
	uchar		*bp;			/* base pointer */
	uchar		*rp;			/* read pointer */
	uchar		*wp;			/* write pointer */
	uchar		*ep;			/* current end */
	uchar		*ebp;			/* end of allocated space */
};

struct Msg {
	Conn		*c;			/* Msg allocated with Conn c */
	int		type;			/* Msg type read/to write */
	u32int		chan;
	Msg		*link;			/* chain */

	Blob		b;
};

struct MsgQueue {
	Msg		*head;
	Msg		**tail;
};

struct Impl {
	char*		name;
};

struct Impllist {
	int		nimpl;
	Impl**		impl;
};

struct Namelist {
	int		nstr;
	char		*str;
	char		**strtab;
};

struct Cert {
	char		*name;			/* protocol name */
	ulong		flags;			/* sign, encrypt */
	CertState	*state;			/* always nil for CertImpl */
	Cert*		(*gen)(void*);
	void		(*free)(Cert*);
	int		(*compare)(Cert*, Cert*);
	void		(*encrypt)(Cert*, uchar*, int);
	void		(*decrypt)(Cert*, uchar*, int);
	Sig*		(*sign)(Cert*, uchar*, int);
	int		(*verify)(Cert*, Sig*, uchar*, int);
	void		(*digest)(Cert*, uchar*, int, DigestFn, int);

	/* Private interfaces; use certpubdecode, et al. instead */
	Cert*		(*pubdecode)(Blob*);
	int		(*pubencode)(Cert*, Blob*);

	Cert*		(*pubparse)(char*);
	int		(*pubprint)(Cert*, Biobuf*);

	Cert*		(*privparse)(char*);
	int		(*privprint)(Cert*, Biobuf*);

	int		(*pubsize)(Cert*);		/* sizecert */
};

struct CertList {
	Cert		*cert;
	CertList	*link;
};

struct Sig {
	char		*name;
	SigState	*state;			/* always nil for SigImpl */
	void		(*free)(Sig*);
	int		(*encode)(Sig*, Blob*);

	/* Private interface; use getsig instead */
	Sig*		(*decode)(Blob*);
	int		(*size)(Sig*);
};

struct Auth {					/* client auth, client side */
	char*		name;			/* SSH protocol name */
	int		(*init)(Conn*, AuthContext**);
	int		(*run)(Conn*, Channel*, Channel*, AuthContext*, char*);
};

struct Authsrv {				/* client auth, server side */
	char*		name;			/* SSH protocol name */
	int		firstmsg;
	AuthInfo*	(*server)(Conn*, Channel*, Channel*, Msg*);
};

struct Cipher {
	char*		name;
	int		blksz;
	int		keylen;
	int		ivlen;
	CipherState*	(*init)(Conn*, Blob*, Blob*);
	void		(*free)(CipherState*);
	void		(*encrypt)(CipherState*, uchar*, int);
	void		(*decrypt)(CipherState*, uchar*, int);
};

struct Digest {
	char		*name;
	int		digestlen;

	/* A DigestFn */
	DigestState*	(*digest)(uchar*, ulong, uchar*, DigestState*);
};

struct Hmac {
	char*		name;			/* protocol name for MAC */
	int		keylen;
	int		hmaclen;
	HmacState*	(*init)(Conn*, Blob*);	/* nil blob --> unkeyed */
	void		(*free)(HmacState*);
	void		(*hmac)(HmacState*, uchar*, int, uchar*);
};

struct Kex {
	char*		name;
	u32int		flags;		/* host key algorithm requirements */
	Digest*		digest;
	KexState*	(*init)(Conn*, Blob*, Blob*);
	void		(*free)(KexState*);
	int		(*client)(Conn*, Channel*, Channel*);
	int		(*server)(Conn*, Channel*, Channel*);
};

/* XXX: key exchange algorithm-specific */
struct DHGroup {
	int		bits;
	int		niter;
	mpint		*g;
	mpint		*p;
	DHGroup		*link;
};

extern	int		doabort;		/* call abort on panic */
extern	int		strict;			/* strict host key checking */
extern	int		verbose;		/* be chatty */
extern	u32int		dbglevel;		/* debug mask */
extern	char		*dbgname;

extern	char		Edecode[];
extern	char		Eencode[];
extern	char		Ebadmac[];
extern	char		Ememory[];
extern	char		Ehungup[];
extern	char		Enotimpl[];
extern	char		Ebotch[];

extern	Auth		authpassword;
extern	Auth		authpublickey;
extern	Auth		authkbdinteractive;

extern	Authsrv		authsrvpassword;
extern	Authsrv		authsrvpublickey;
extern	Authsrv		authsrvkbdinteractive;

extern	CertImpl	certsshdss;
extern	CertImpl	certsshrsa;

extern	SigImpl		sigsshdss;
extern	SigImpl		sigsshrsa;

extern	Cipher		cipher3des;
extern	Cipher		cipheraes128;
extern	Cipher		cipheraes192;
extern	Cipher		cipheraes256;
extern	Cipher		cipherblowfish;
extern	Cipher		cipherdes;
extern	Cipher		cipherrc4;
extern	Cipher		ciphernone;

extern	Digest		digestmd5;
extern	Digest		digestsha1;

extern	Hmac		hmacsha1;
extern	Hmac		hmacmd5;

extern	Kex		kexdh;
extern	Kex		kexdhgex;

/* protocol message and disconnect numbers */
enum {
	MSGIGN					= 0,
	SSH_MSG_MIN				= 0,
	SSH_MSG_MAX				= 255,
	SSH_MSG_XPORT_MIN			= 1,	/* transport layer */
	SSH_MSG_XPORT_MAX			= 19,
	SSH_MSG_ALG_MIN				= 20,	/* algorithm negot. */
	SSH_MSG_ALG_MAX				= 29,
	SSH_MSG_KEX_MIN				= 30,	/* key exchange */
	SSH_MSG_KEX_MAX				= 49,
	SSH_MSG_AUTH_MIN			= 50,	/* authentication */
	SSH_MSG_AUTH_MAX			= 79,
	SSH_MSG_CONN_MIN			= 80,	/* connection layer */
	SSH_MSG_CONN_MAX			= 127,
	SSH_MSG_LOCAL_MIN			= 192,
	SSH_MSG_LOCAL_MAX			= 255
};

enum {
	SSH_MSG_DISCONNECT			= 1,
	SSH_MSG_IGNORE,
	SSH_MSG_UNIMPLEMENTED,
	SSH_MSG_DEBUG,
	SSH_MSG_SERVICE_REQUEST,
	SSH_MSG_SERVICE_ACCEPT,

	SSH_MSG_KEXINIT				= 20,
	SSH_MSG_NEWKEYS,

	SSH_MSG_KEXDH_INIT			= 30,
	SSH_MSG_KEXDH_REPLY			= 31,

	SSH_MSG_USERAUTH_REQUEST		= 50,
	SSH_MSG_USERAUTH_FAILURE,
	SSH_MSG_USERAUTH_SUCCESS,
	SSH_MSG_USERAUTH_BANNER,

	SSH_MSG_GLOBAL_REQUEST			= 80,
	SSH_MSG_REQUEST_SUCCESS,
	SSH_MSG_REQUEST_FAILURE,

	SSH_MSG_CHANNEL_OPEN			= 90,
	SSH_MSG_CHANNEL_OPEN_CONFIRMATION,
	SSH_MSG_CHANNEL_OPEN_FAILURE,
	SSH_MSG_CHANNEL_WINDOW_ADJUST,
	SSH_MSG_CHANNEL_DATA,
	SSH_MSG_CHANNEL_EXTENDED_DATA,
	SSH_MSG_CHANNEL_EOF,
	SSH_MSG_CHANNEL_CLOSE,
	SSH_MSG_CHANNEL_REQUEST,
	SSH_MSG_CHANNEL_SUCCESS,
	SSH_MSG_CHANNEL_FAILURE
};

enum {
	SSH_DISCONNECT_HOST_NOT_ALLOWED_TO_CONNECT	= 1,
	SSH_DISCONNECT_PROTOCOL_ERROR,
	SSH_DISCONNECT_KEY_EXCHANGE_FAILED,
	SSH_DISCONNECT_RESERVED,
	SSH_DISCONNECT_MAC_ERROR,
	SSH_DISCONNECT_COMPRESSION_ERROR,
	SSH_DISCONNECT_SERVICE_NOT_AVAILABLE,
	SSH_DISCONNECT_PROTOCOL_VERSION_NOT_SUPPORTED,
	SSH_DISCONNECT_HOST_KEY_NOT_VERIFIABLE,
	SSH_DISCONNECT_CONNECTION_LOST,
	SSH_DISCONNECT_BY_APPLICATION,
	SSH_DISCONNECT_TOO_MANY_CONNECTIONS,
	SSH_DISCONNECT_AUTH_CANCELLED_BY_USER,
	SSH_DISCONNECT_NO_MORE_AUTH_METHODS_AVAILABLE,
	SSH_DISCONNECT_ILLEGAL_USER_NAME
};
