#include "dat.h"
#include "fns.h"

/*
 * Conn is implicitly locked as all accesses are from the same proc.
 */

static	char	*cleanhost(char*);

static	Conn	*conntab;

Conn*
mkconn(int role, char *user, char *host, char *cfgname)
{
	int n;
	char *s;
	Conn *c;
	Cfg *cfg;

	c = emalloc(sizeof *c);
	c->link = conntab;
	conntab = c;

	c->role = role;
	c->dislock = chancreate(sizeof(void*), 0);

	c->user = user ? estrdup(user) : nil;
	c->host = cleanhost(host);

	/* XXX: overkill */
//	Binit(&c->bstdout, 1, OWRITE);
	Binit(&c->bstderr, 2, OWRITE);

	/* load configuration and then set defaults if need be */
	cfg = mkcfg(c, cfgname, role, host, user);
	if(cfg == nil){
		werrstr("can't read configuration");
		goto Error;
	}
	c->cfg = cfg;

	/* set default host certificate database file */
	s = esmprint("%s/%s/keyring", syshome(), syscfgdir());
	cfgdefault(c, "hostcertdb", s);
	free(s);

	s = esmprint("%s/%s/identity", syshome(), syscfgdir());
	cfgdefault(c, "usercertdb", s);
	free(s);

	/* XXX: set dhgpfile default */

	/* load algorithms and set defaults as necessary */
	if(cfgloadimpl(c, &c->okkex, "kex") < 0 ||
	   cfgloadimpl(c, &c->okauth, "auth") < 0 ||
	   cfgloadimpl(c, &c->okauthsrv, "authsrv") < 0 ||
	   cfgloadimpl(c, &c->okhostcert, "cert") < 0 ||
	   cfgloadimpl(c, &c->okhostsig, "sig") < 0 ||
	   cfgloadimpl(c, &c->okcipher, "cipher") < 0 ||
	   cfgloadimpl(c, &c->okhmac, "hmac") < 0)
		goto Error;

	/* Now that we know how many to allocate, set up Conn->authcontext */
	n = c->okauth->nimpl;
	if(n < c->okauthsrv->nimpl)
		n = c->okauthsrv->nimpl;
	c->nauthcontext = n;
	c->authcontext = emalloc(n*sizeof(c->authcontext[0]));

	cfgoptions(c);
	return c;

 Error:
	freeconn(c);
	return nil;
}

void
connsetfd(Conn *c, int fd[2])
{
	int i;

	for(i=0; i<2; i++){
		c->fd[i] = fd[i];
		c->io[i] = ioproc();
		c->keylock[i] = chancreate(sizeof(void*), 0);
	}

	return;
}

void
freeconn(Conn *c)
{
	int i;
	Conn **l;

	if(c == nil)
		return;

	if(c->wirestate != WShup)
		error(c, "freeconn: still connected; 0x%lux", getcallerpc(&c));

	/* remove this connection from the list */
	for(l=&conntab; *l != nil; l=&(*l)->link)
		if(*l == c){
			*l = (*l)->link;
			break;
		}

	for(i=0; i<2; i++){
		if(c->io[i] != nil){
			iointerrupt(c->io[i]);
			//closeioproc(c->io[i]);
		}
		if(c->keylock[i] != nil)
			chanfree(c->keylock[i]);
	}
	if(c->dislock != nil)
		chanfree(c->dislock);

	memset(c->seqno, 0, sizeof c->seqno);
	freecfg(c->cfg);
	clearblob(c->sessionid);
	free(c->cversion);
	free(c->sversion);
	free(c->user);
	free(c->host);

//	Bterm(&c->bstdout);
	Bterm(&c->bstderr);

	if(c->kexstate != nil){
		assert(c->kex != nil);
		c->kex->free(c->kexstate);
	}
	c->kex = nil;			/* statically allocated */
	freeimpllist(c->okkex);		/* free only list of pointers */

	c->auth = nil;			/* statically allocated */
	freeimpllist(c->okauth);
	c->authsrv = nil;		/* statically allocated */
	freeimpllist(c->okauthsrv);
	freecertlist(c->authcerts);

	freenamelist(c->authlist);
	for(i=0; i<c->nauthcontext; i++)/* just blocks of memory */
		free(c->authcontext[i]);
	free(c->authcontext);

	if(c->hostcert != nil)
		c->hostcert->free(c->hostcert);
	freeimpllist(c->okhostcert);	/* free only list of pointers */

	if(c->hostsig != nil)
		c->hostsig->free(c->hostsig);
	freeimpllist(c->okhostsig);	/* free only list of pointers */

	for(i=0; i<2; i++){
		if(c->cipherstate[i] != nil){
			assert(c->cipher[i] != nil);
			c->cipher[i]->free(c->cipherstate[i]);
		}
		c->cipher[i] = nil;	/* statically allocated */

		if(c->hmacstate[i] != nil){
			assert(c->hmac[i] != nil);
			c->hmac[i]->free(c->hmacstate[i]);
		}
		c->hmac[i] = nil;	/* statically allocated */
		free(c->digest[i]);
	}

	freeimpllist(c->okcipher);	/* free only list of pointers */
	freeimpllist(c->okhmac);	/* free only list of pointers */

	clearblob(c->kexkey);
	clearblob(c->kexhash);
	clearblob(c->kexblob[0]);
	clearblob(c->kexblob[1]);

	memset(c, 0xCAFED00D, sizeof *c);

	return;
}

int
cfgloadimpl(Conn *c, Impllist **il, char *key)
{
	char *val;
	Namelist *nl;

	nl = nil;
	val = cfgstr(c, key);
	if(val != nil){
		nl = parsenamelist(val);
		debug(DbgCfg, "cfgloadimpl %s --> %N", key, nl);
	}
	*il = loadimpl(c, key, nl);
	freenamelist(nl);
	if(*il == nil){	/* XXX: probably could be caught by cfg.c */
		werrstr("empty configuration list for '%s'", key);
		return -1;
	}
	if(val == nil){
		val = consimpllist(*il);
		debug(DbgCfg, "cfgloadimpl %s --> %s", key, val);
		cfgdefault(c, key, val);
		free(val);
	}

	return 0;
}

void
conncleanup(void)
{
	Conn *c, *tc;

	debug(DbgDebug, "conncleanup");

	c=conntab;
	while(c != nil){
		tc = c;
		c = c->link;
		debug(DbgDebug, "conncleanup: freeconn(0x%lux)", tc);
		freeconn(tc);
	}

	return;
}

/* XXX: we may wish to preserve the network and port somewhere */
static char*
cleanhost(char *h)
{
	char *s, *t;

	s = strchr(h, '!');
	if(s == nil)
		return estrdup(h);
	s = estrdup(s+1);
	t = strchr(s, '!');
	if(t != nil)
		*t = '\0';
	return s;
}
