#include "dat.h"
#include "fns.h"

struct CipherState {
	RC4state	csrc4;
};

static CipherState*
initrc4(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	USED(iv);
	if(key->wp - key->bp < 16)
		panic("initrc4: key or initialization vector too short");

	s = emalloc(sizeof *s);
	setupRC4state(&s->csrc4, key->bp, 16);
	return s;
}

static void
freerc4(CipherState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
encryptrc4(CipherState *s, uchar *b, int n)
{
	rc4(&s->csrc4, b, n);	/* sic */
}

Cipher cipherrc4 = {
	"arcfour",
	8,			/* block size; (min. even for stream cipher) */
	16,			/* key length */
	0,			/* initialization vector length */
	initrc4,
	freerc4,
	encryptrc4,
	encryptrc4		/* sic */
};
