#include "dat.h"
#include "fns.h"

struct CipherState {
	int	notused;
};

static CipherState*
initnone(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	USED(iv);
	USED(key);

	s = emalloc(sizeof *s);
	return s;
}

static void
freenone(CipherState *s)
{
	memset(s, 0, sizeof *s);		/* XXX: symmetry */
	free(s);
}

static void
cryptnone(CipherState *s, uchar *b, int n)
{
	return;
}

Cipher ciphernone = {
	"none",
	8,			/* block size; (min. even for stream cipher) */
	0,			/* key length */
	0,			/* initialization vector length */
	initnone,
	freenone,
	cryptnone,
	cryptnone		/* sic */
};
