#include "dat.h"
#include "fns.h"

struct CipherState {
	DESstate	csdes;
};

static CipherState*
initdes(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	if(key->wp - key->bp < 8 || iv->wp - key->bp < DESbsize)
		panic("initdes: key or initialization vector too short");

	s = emalloc(sizeof *s);
	setupDESstate(&s->csdes, key->bp, iv->bp);
	return s;
}

static void
freedes(CipherState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
encryptdes(CipherState *s, uchar *b, int n)
{
	desCBCencrypt(b, n, &s->csdes);
}

static void
decryptdes(CipherState *s, uchar *b, int n)
{
	desCBCdecrypt(b, n, &s->csdes);
}

Cipher cipherdes = {
	"des-cbc",
	DESbsize,		/* block size */
	8,			/* key length */
	DESbsize,		/* initialization vector length */
	initdes,
	freedes,
	encryptdes,
	decryptdes
};
