#include "dat.h"
#include "fns.h"

struct CipherState {
	BFstate		csbf;
};

static CipherState*
initbf(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	if(key->wp - key->bp < 16 || iv->wp - iv->bp < BFbsize)
		panic("initbf: key or initialization vector too short");

	s = emalloc(sizeof *s);
	setupBFstate(&s->csbf, key->bp, 16, iv->bp);
	return s;
}

static void
freebf(CipherState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
encryptbf(CipherState *s, uchar *b, int n)
{
	bfCBCencrypt(b, n, &s->csbf);
}

static void
decryptbf(CipherState *s, uchar *b, int n)
{
	bfCBCdecrypt(b, n, &s->csbf);
}

Cipher cipherblowfish = {
	"blowfish-cbc",
	BFbsize,		/* block size */
	8,			/* key length */
	BFbsize,		/* initialization vector length */
	initbf,
	freebf,
	encryptbf,
	decryptbf
};
