#include "dat.h"
#include "fns.h"

struct CipherState {
	int		keybytes;
	AESstate	csaes;
};

char Eaesbadarg[] = "initaes%d: key or initialization vector too short";

static CipherState*
initaes128(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	if(key->wp - key->bp < 16 || iv->wp - iv->bp < AESbsize)
		panic(Eaesbadarg, 128);

	s = emalloc(sizeof *s);
	setupAESstate(&s->csaes, key->bp, 16, iv->bp);
	return s;
}

static CipherState*
initaes192(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	if(key->wp - key->bp < 24 || iv->wp - iv->bp < AESbsize)
		panic(Eaesbadarg, 192);

	s = emalloc(sizeof *s);
	setupAESstate(&s->csaes, key->bp, 24, iv->bp);
	return s;
}

static CipherState*
initaes256(Conn *c, Blob *key, Blob *iv)
{
	CipherState *s;

	if(key->wp - key->bp < 32 || iv->wp - iv->bp < AESbsize)
		panic(Eaesbadarg, 256);

	s = emalloc(sizeof *s);
	setupAESstate(&s->csaes, key->bp, 32, iv->bp);
	return s;
}

static void
freeaes(CipherState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
encryptaes(CipherState *s, uchar *b, int n)
{
	aesCBCencrypt(b, n, &s->csaes);
}

static void
decryptaes(CipherState *s, uchar *b, int n)
{
	aesCBCdecrypt(b, n, &s->csaes);
}

Cipher cipheraes128 = {
	"aes128-cbc",
	AESbsize,		/* block size */
	16,			/* key length */
	AESbsize,		/* initialization vector length */
	initaes128,
	freeaes,
	encryptaes,
	decryptaes
};

Cipher cipheraes192 = {
	"aes192-cbc",
	AESbsize,		/* block size */
	24,			/* key length */
	AESbsize,		/* initialization vector length */
	initaes192,
	freeaes,
	encryptaes,
	decryptaes
};

Cipher cipheraes256 = {
	"aes256-cbc",
	AESbsize,		/* block size */
	32,			/* key length */
	AESbsize,		/* initialization vector length */
	initaes256,
	freeaes,
	encryptaes,
	decryptaes
};
