#include "dat.h"
#include "fns.h"

/* Triple DES by default is EDE */
struct CipherState {
	DES3state	cs3des;
};

static CipherState*
init3des(Conn *c, Blob *key, Blob *iv)
{
	int i;
	uchar keys[3][8];
	CipherState *s;

	if(key->wp - key->bp < 3*8 || iv->wp - iv->bp < 3*8)
		panic("init3des: key or initialization vector too short");

	s = emalloc(sizeof *s);
	for(i=0; i<3; i++)
		memmove(keys[i], key->bp+8*i, 8);
	setupDES3state(&s->cs3des, keys, iv->bp);
	return s;
}

static void
free3des(CipherState *s)
{
	memset(s, 0, sizeof *s);
	free(s);
}

static void
encrypt3des(CipherState *s, uchar *b, int n)
{
	des3CBCencrypt(b, n, &s->cs3des);
}

static void
decrypt3des(CipherState *s, uchar *b, int n)
{
	des3CBCdecrypt(b, n, &s->cs3des);
}

Cipher cipher3des = {
	"3des-cbc",
	DESbsize,		/* block size */
	3*8,			/* key length */
	3*DESbsize,		/* initialization vector length */
	init3des,
	free3des,
	encrypt3des,
	decrypt3des
};
