#include "dat.h"
#include "fns.h"

Blob*
mkblob(ulong n)
{
	Blob *p;

	p = emalloc(sizeof(*p)+ n);
	p->bp = (uchar*)p + sizeof(*p);
	p->wp = p->bp;
	p->rp = p->bp;
	p->ep = p->ebp = p->bp+n;

	return p;
}

Blob*
blobrealloc(Blob *b, ulong n)
{
	Blob *nb;
	ulong rpo, wpo, epo;

	if(n <= b->ebp - b->bp){
		b->ep = b->bp+n;
		return b;
	}

	rpo = b->rp - b->bp;
	wpo = b->wp - b->bp;
	epo = b->ep - b->bp;

	nb = mkblob(n);
	memmove(nb->bp, b->bp, wpo);
	b->rp = b->bp+rpo;
	b->wp = b->bp+wpo;
	b->ep = b->bp+epo;
	freeblob(b);

	return nb;
}

void
freeblob(Blob *p)
{
	free(p);
}

void
clearblob(Blob *p)
{
	if(p == nil)
		return;
	if(dbglevel == 0)	/* don't zero interesting things out */
		memset(p->bp, 0, p->wp - p->bp);
	freeblob(p);
}

Blob*
copyblob(uchar *buf, ulong len)
{
	Blob *b;

	b = mkblob(len);
	memmove(b->bp, buf, len);
	b->wp = b->bp + len;

	return b;
}

int
sizeblob(Blob *b)
{
	return b->wp - b->bp;
}
