#include "dat.h"
#include "fns.h"

enum {
	SSH_MSG_USERAUTH_PASSWD_CHANGEREQ = 60
};

struct AuthContext {
	int	ntries;
};

static	char	*msgnameauthpass(int);

static int
authpassinit(Conn *c, AuthContext **ctx)
{
	if(*ctx == nil)
		*ctx = emalloc(sizeof **ctx);
	debug(DbgAuth, "authpassinit %d", (*ctx)->ntries);
	c->msgnameauth = msgnameauthpass;
	return 0;
}

static int
authpass(Conn *c, Channel *rc, Channel *wc, AuthContext *ctx, char *service)
{
	int n;
	int rv;
	Msg *m;
	char *prompt, *passwd;

	USED(rc);

	rv = UAfail;
	ctx->ntries++;
	assert(ctx->ntries <= AuthPassTries);

	prompt = esmprint("%s@%s's password: ", c->user, c->host);
	passwd = sysgetpass(prompt);
	n = strlen(passwd);
	free(prompt);

	m = ssh_msg_userauthreq(c, service, "password");
	putbool(&m->b, 0);		/* password change ==> no */
	putstring(&m->b, passwd);	/* XXX: convert to ISO-10646 UTF-8 */
	memset(passwd, 0, n);
	sendmsg(wc, m);
	debug(DbgAuth, "authpass: password sent");

	m = authrecvmsg(c, rc, MSGIGN);
	switch(m->type){
	case SSH_MSG_USERAUTH_PASSWD_CHANGEREQ:
		/*
		 * XXX: password change request not supported.
		 * Unconditionally fail this method and have it
		 * removed from the list of things to try
		 */
		freemsg(m);
		debug(DbgAuth,"SSH_MSG_USERAUTH_PASSWD_CHANGEREQ --> failure");
		break;

	default:
		/* try up to AuthPassTries times on failure */
		rv = authgeneric(c, rc, wc, m, ctx->ntries < AuthPassTries);
		break;
	}

	return rv;
}

static char*
msgnameauthpass(int t)
{
	if(t == SSH_MSG_USERAUTH_PASSWD_CHANGEREQ)
		return "SSH_MSG_USERAUTH_PASSWD_CHANGEREQ";
	return "<unknown>";
}

Auth authpassword = {
	"password",
	authpassinit,
	authpass
};
