#include "dat.h"
#include "fns.h"

enum {
	SSH_MSG_USERAUTH_INFO_REQUEST	= 60,
	SSH_MSG_USERAUTH_INFO_RESPONSE,
};

struct AuthContext {
	int	ntries;
};

static	char	*msgnameauthkbd(int);

static int
authkbdinit(Conn *c, AuthContext **ctx)
{
	if(*ctx == nil)
		*ctx = emalloc(sizeof **ctx);
	debug(DbgAuth, "authkbdinit %d", (*ctx)->ntries);
	c->msgnameauth = msgnameauthkbd;
	return 0;
}

static int
authkbd(Conn *c, Channel *rc, Channel *wc, AuthContext *ctx, char *service)
{
	int nresponse;
	int i, n, e, rv;
	char *prompt, *name;
	char *instruction, *pref;
	char **response;

	Msg *m;
	Namelist *nl;

	USED(rc);

	rv = UAfail;
	ctx->ntries++;
	assert(ctx->ntries <= AuthKbdTries);

	nresponse = 0;
	response = nil;

	nl = cfgnamelist(c, "kbdmethods");
	if(nl != nil)
		pref = esmprint("%N", nl);
	else
		pref = estrdup("");
	debug(DbgAuth, "keyboard-interactive: preferences=%N", nl);
	m = ssh_msg_userauthreq(c, service, "keyboard-interactive");
	putstring(&m->b, "");		/* bogus language tag */
	putstring(&m->b, pref);		/* submethod preferences */
	sendmsg(wc, m);
	free(pref);
	freenamelist(nl);

	m = authrecvmsg(c, rc, MSGIGN);
	while(m->type == SSH_MSG_USERAUTH_INFO_REQUEST){
		name = getstring(&m->b);
		instruction = getstring(&m->b);
		getstring(&m->b);			/* language tag */
		n = getlong(&m->b);
		if(n < 0)
			goto Error;
		debug(DbgAuth, "received %d prompt%s", n, n==1?"":"s");
		filterstring(name);
		filterstring(instruction);
		if(*name != '\0')
			print("%s\n", name);
		if(*instruction != '\0')
			print("%s\n", instruction);
		nresponse = 0;
		response = emalloc(n*sizeof(*response));
		for(i=0; i<n; i++){
			prompt = getstring(&m->b);
			filterstring(prompt);
			e = getbool(&m->b);
			/* XXX: should permit echo if e is true */
			response[nresponse] = sysgetpass(prompt);
			if(response[nresponse] == nil ||
			   *response[nresponse] == '\0')
				break;
			nresponse++;
		}
		m = allocmsg(c, SSH_MSG_USERAUTH_INFO_RESPONSE, 0);
		if(nresponse != n)
			putlong(&m->b, 0);
		else{
			putlong(&m->b, nresponse);
			for(i=0; i<nresponse; i++)
				putstring(&m->b, response[i]);
		}
		for(i=0; i<nresponse; i++)
			memset(response[i], 0, strlen(response[i]));
		free(response[i]);
		free(response);
		response = nil;
		debug(DbgAuth, "sending %d response%s", nresponse,
		      nresponse==1?"":"s");
		sendmsg(wc, m);
		m = authrecvmsg(c, rc, MSGIGN);
	}

	/* try up to AuthKbdTries times on failure */
	rv = authgeneric(c, rc, wc, m, ctx->ntries < AuthKbdTries);

	return rv;

 Error:
	freemsg(m);
	if(response != nil){
		for(i=0; i<nresponse; i++)
			memset(response[i], 0, strlen(response[i]));
		free(response[i]);
		free(response);
	}
	return UAfail;
}

static char*
msgnameauthkbd(int t)
{
	switch(t){
	case SSH_MSG_USERAUTH_INFO_REQUEST:
		return "SSH_MSG_USERAUTH_INFO_REQUEST";

	case SSH_MSG_USERAUTH_INFO_RESPONSE:
		return "SSH_MSG_USERAUTH_INFO_RESPONSE";

	default:
		return "<unknown>";
	}
}

Auth authkbdinteractive = {
	"keyboard-interactive",
	authkbdinit,
	authkbd
};
