#include "dat.h"
#include "fns.h"

typedef struct Alarm Alarm;

enum {
	Oneshot	= 0,
	Random,
	Recur
};

struct Alarm {
	char	*msg;
	int	delta;		/* milliseconds */
	int	type;
	ulong	expire;		/* next scheduled expiry */
};

static	void	alarmproc(void*);

void
alarminit(Channel *c)
{
	proccreate(alarmproc, c, 8192);
}

/*
 * Regularly scheduled events
 *
 * XXX: NOP messages are a crude attempt at using randomization to
 * thwart traffic analysis.  At the least, it will require tweaking
 * parameters.  In the meantime it stresses the transport layer a bit.
 *
 * XXX: Key re-exchange should depend upon data flow, not (just)
 * elapsed time.
 */

static Alarm alarmtab[] = {
	/* msg,		delta,		type,		expire */
	{ "auth", 	10*60*1000, 	Oneshot, 	0 },
//	{ "kex", 	60*60*1000, 	Recur, 		0 },
//	{ "nop", 	4096, 		Random, 	0 },
	{ "debug", 	0, 		Oneshot, 	~0 },
	{ nil, 		0, 		0, 		0 }
};

static void
alarmproc(void *arg)
{
	int min;
	int i, n;
	ulong now;
	ulong next;
	Channel *c;

	c = (Channel*)arg;

	now = time(nil)*1000;
	min = nrand(1024);
	for(i=0; alarmtab[i].msg != nil; i++)
		if(alarmtab[i].expire == 0)
			alarmtab[i].expire = now+alarmtab[i].delta;

	for(;;){
		now = time(nil)*1000;
		for(i=0; alarmtab[i].msg != nil; i++){
			if(alarmtab[i].expire == ~0)
				continue;
			/* find expired events, send them, and reschedule */
			if(now >= alarmtab[i].expire+100){
				sendp(c, alarmtab[i].msg);
				switch(alarmtab[i].type){
				case Random:
					n = nrand(alarmtab[i].delta);
					alarmtab[i].expire = now + min + n;
					break;

				case Recur:
					alarmtab[i].expire = alarmtab[i].delta;
					alarmtab[i].expire += now;
					break;

				case Oneshot:
					alarmtab[i].expire = ~0;
					break;

				default:
					panic(Ebotch);
					break;
				}
			}
		}

		/* sleep until something interesting happens */
		next = alarmtab[0].expire;
		for(i=1; alarmtab[i].msg != nil; i++)
			if(next > alarmtab[i].expire)
				next = alarmtab[i].expire;

		next -= now;
		n = nrand(1024) - 512;
		sleep(next+n);
	}

	panic(Ebotch);
	return;
}

