7. Key Re-Exchange

   Key re-exchange is started by sending an SSH_MSG_KEXINIT packet when
   not already doing a key exchange (as described in Section Section
   5.1).  When this message is received, a party MUST respond with its
   own SSH_MSG_KEXINIT message except when the received SSH_MSG_KEXINIT



Ylonen, et. al.          Expires March 21, 2003                [Page 19]

Internet-Draft        SSH Transport Layer Protocol        September 2002


   already was a reply.  Either party MAY initiate the re-exchange, but
   roles MUST NOT be changed (i.e., the server remains the server, and
   the client remains the client).


   Key re-exchange is performed using whatever encryption was in effect
   when the exchange was started.  Encryption, compression, and MAC
   methods are not changed before a new SSH_MSG_NEWKEYS is sent after
   the key exchange (as in the initial key exchange).  Re-exchange is
   processed identically to the initial key exchange, except for the
   session identifier that will remain unchanged.  It is permissible to
   change some or all of the algorithms during the re-exchange.  Host
   keys can also change.  All keys and initialization vectors are
   recomputed after the exchange.  Compression and encryption contexts
   are reset.


   It is recommended that the keys are changed after each gigabyte of
   transmitted data or after each hour of connection time, whichever
   comes sooner.  However, since the re-exchange is a public key
   operation, it requires a fair amount of processing power and should
   not be performed too often.


   More application data may be sent after the SSH_MSG_NEWKEYS packet
   has been sent; key exchange does not affect the protocols that lie
   above the SSH transport layer.

