
6. Diffie-Hellman Key Exchange

   The Diffie-Hellman key exchange provides a shared secret that can not
   be determined by either party alone.  The key exchange is combined
   with a signature with the host key to provide host authentication.


   In the following description (C is the client, S is the server; p is
   a large safe prime, g is a generator for a subgroup of GF(p), and q
   is the order of the subgroup; V_S is S's version string; V_C is C's
   version string; K_S is S's public host key; I_C is C's KEXINIT
   message and I_S S's KEXINIT message which have been exchanged before
   this part begins):


   1.  C generates a random number x (1 < x < q) and computes e = g^x
       mod p.  C sends "e" to S.



Ylonen, et. al.          Expires March 21, 2003                [Page 17]


   2.  S generates a random number y (0 < y < q) and computes f = g^y
       mod p.  S receives "e".  It computes K = e^y mod p, H = hash(V_C
       || V_S || I_C || I_S || K_S || e || f || K) (these elements are
       encoded according to their types; see below), and signature s on
       H with its private host key.  S sends "K_S || f || s" to C.  The
       signing operation may involve a second hashing operation.

   3.  C verifies that K_S really is the host key for S (e.g.  using
       certificates or a local database).  C is also allowed to accept
       the key without verification; however, doing so will render the
       protocol insecure against active attacks (but may be desirable
       for practical reasons in the short term in many environments).  C
       then computes K = f^x mod p, H = hash(V_C || V_S || I_C || I_S ||
       K_S || e || f || K), and verifies the signature s on H.

   Either side MUST NOT send or accept e or f values that are not in the
   range [1, p-1].  If this condition is violated, the key exchange
   fails.


   This is implemented with the following messages.  The hash algorithm
   for computing the exchange hash is defined by the method name, and is
   called HASH.  The public key algorithm for signing is negotiated with
   the KEXINIT messages.

   First, the client sends the following:

     byte      SSH_MSG_KEXDH_INIT
     mpint     e


   The server responds with the following:

     byte      SSH_MSG_KEXDH_REPLY
     string    server public host key and certificates (K_S)
     mpint     f
     string    signature of H

   The hash H is computed as the HASH hash of the concatenation of the
   following:

     string    V_C, the client's version string (CR and NL excluded)
     string    V_S, the server's version string (CR and NL excluded)
     string    I_C, the payload of the client's SSH_MSG_KEXINIT
     string    I_S, the payload of the server's SSH_MSG_KEXINIT
     string    K_S, the host key
     mpint     e, exchange value sent by the client
     mpint     f, exchange value sent by the server
     mpint     K, the shared secret




Ylonen, et. al.          Expires March 21, 2003                [Page 18]

Internet-Draft        SSH Transport Layer Protocol        September 2002


   This value is called the exchange hash, and it is used to
   authenticate the key exchange.  The exchange hash SHOULD be kept
   secret.


   The signature algorithm MUST be applied over H, not the original
   data.  Most signature algorithms include hashing and additional
   padding.  For example, "ssh-dss" specifies SHA-1 hashing; in that
   case, the data is first hashed with HASH to compute H, and H is then
   hashed with SHA-1 as part of the signing operation.

6.1 diffie-hellman-group1-sha1

   The "diffie-hellman-group1-sha1" method specifies Diffie-Hellman key
   exchange with SHA-1 as HASH, and the following group:

   The prime p is equal to 2^1024 - 2^960 - 1 + 2^64 * floor( 2^894 Pi +
   129093 ).  Its hexadecimal value is:

         FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
         29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
         EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
         E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
         EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE65381
         FFFFFFFF FFFFFFFF.

   In decimal, this value is:

         179769313486231590770839156793787453197860296048756011706444
         423684197180216158519368947833795864925541502180565485980503
         646440548199239100050792877003355816639229553136239076508735
         759914822574862575007425302077447712589550957937778424442426
         617334727629299387668709205606050270810842907692932019128194
         467627007.

   The generator used with this prime is g = 2.  The group order q is (p
   - 1) / 2.

   This group was taken from the ISAKMP/Oakley specification, and was
   originally generated by Richard Schroeppel at the University of
   Arizona.  Properties of this prime are described in [Orm96].

