#include "ssh.h"

int
kex(Conn *z)
{
	Msg *m;
	
	m = msgalloc();
	msgwrite(m, z->cookie, 16);
	msgwritestring(m, kexalgs);
	msgwritestring(m, serverhostkeyalgs);
	msgwritestring(m, encalgs);	/* c2s */
	msgwritestring(m, encalgs);	/* s2c */
	msgwritestring(m, macalgs);	/* c2s */
	msgwritestring(m, macalgs);	/* s2c */
	msgwritestring(m, compressalgs);	/* c2s */
	msgwritestring(m, compressalgs);	/* s2c */
	msgwritestring(m, languages);	/* c2s */
	msgwritestring(m, languages);	/* s2c */
	msgwritebool(m, 0);
	msgwriteuint32(m, 0);
	connwrite(z, m);
	
	
	
	m = connread(z);
	if(msgreadn(m, z->rcookie, 16)
}


/*
5. Key Exchange

   Key exchange begins by each side sending lists of supported
   algorithms.  Each side has a preferred algorithm in each category,
   and it is assumed that most implementations at any given time will
   use the same preferred algorithm.  Each side MAY guess which
   algorithm the other side is using, and MAY send an initial key
   exchange packet according to the algorithm if appropriate for the
   preferred method.

   Guess is considered wrong, if:
   o  the kex algorithm and/or the host key algorithm is guessed wrong
      (server and client have different preferred algorithm), or
   o  if any of the other algorithms cannot be agreed upon (the
      procedure is defined below in Section Section 5.1).

   Otherwise, the guess is considered to be right and the optimistically
   sent packet MUST be handled as the first key exchange packet.

   However, if the guess was wrong, and a packet was optimistically sent
   by one or both parties, such packets MUST be ignored (even if the
   error in the guess would not affect the contents of the initial
   packet(s)), and the appropriate side MUST send the correct initial
   packet.

   Server authentication in the key exchange MAY be implicit.  After a
   key exchange with implicit server authentication, the client MUST
   wait for response to its service request message before sending any
   further data.

5.1 Algorithm Negotiation

   Key exchange begins by each side sending the following packet:

     byte      SSH_MSG_KEXINIT
     byte[16]  cookie (random bytes)
     string    kex_algorithms
     string    server_host_key_algorithms
     string    encryption_algorithms_client_to_server
     string    encryption_algorithms_server_to_client
     string    mac_algorithms_client_to_server
     string    mac_algorithms_server_to_client
     string    compression_algorithms_client_to_server
     string    compression_algorithms_server_to_client
     string    languages_client_to_server
     string    languages_server_to_client



Ylonen, et. al.          Expires March 21, 2003                [Page 13]

Internet-Draft        SSH Transport Layer Protocol        September 2002


     boolean   first_kex_packet_follows
     uint32    0 (reserved for future extension)

   Each of the algorithm strings MUST be a comma-separated list of
   algorithm names (see ''Algorithm Naming'' in [SSH-ARCH]).  Each
   supported (allowed) algorithm MUST be listed in order of preference.

   The first algorithm in each list MUST be the preferred (guessed)
   algorithm.  Each string MUST contain at least one algorithm name.


      cookie
         The cookie MUST be a random value generated by the sender.  Its
         purpose is to make it impossible for either side to fully
         determine the keys and the session identifier.

      kex_algorithms
         Key exchange algorithms were defined above.  The first
         algorithm MUST be the preferred (and guessed) algorithm.  If
         both sides make the same guess, that algorithm MUST be used.
         Otherwise, the following algorithm MUST be used to choose a key
         exchange method: iterate over client's kex algorithms, one at a
         time.  Choose the first algorithm that satisfies the following
         conditions:
         +  the server also supports the algorithm,
         +  if the algorithm requires an encryption-capable host key,
            there is an encryption-capable algorithm on the server's
            server_host_key_algorithms that is also supported by the
            client, and
         +  if the algorithm requires a signature-capable host key,
            there is a signature-capable algorithm on the server's
            server_host_key_algorithms that is also supported by the
            client.
         +  If no algorithm satisfying all these conditions can be
            found, the connection fails, and both sides MUST disconnect.

      server_host_key_algorithms
         List of the algorithms supported for the server host key.  The
         server lists the algorithms for which it has host keys; the
         client lists the algorithms that it is willing to accept.
         (There MAY be multiple host keys for a host, possibly with
         different algorithms.)

         Some host keys may not support both signatures and encryption
         (this can be determined from the algorithm), and thus not all
         host keys are valid for all key exchange methods.

         Algorithm selection depends on whether the chosen key exchange



Ylonen, et. al.          Expires March 21, 2003                [Page 14]

Internet-Draft        SSH Transport Layer Protocol        September 2002


         algorithm requires a signature or encryption capable host key.
         It MUST be possible to determine this from the public key
         algorithm name.  The first algorithm on the client's list that
         satisfies the requirements and is also supported by the server
         MUST be chosen.  If there is no such algorithm, both sides MUST
         disconnect.

      encryption_algorithms
         Lists the acceptable symmetric encryption algorithms in order
         of preference.  The chosen encryption algorithm to each
         direction MUST be the first algorithm  on the client's list
         that is also on the server's list.  If there is no such
         algorithm, both sides MUST disconnect.

         Note that "none" must be explicitly listed if it is to be
         acceptable.  The defined algorithm names are listed in Section
         Section 4.3.

      mac_algorithms
         Lists the acceptable MAC algorithms in order of preference.
         The chosen MAC algorithm MUST be the first algorithm on the
         client's list that is also on the server's list.  If there is
         no such algorithm, both sides MUST disconnect.

         Note that "none" must be explicitly listed if it is to be
         acceptable.  The MAC algorithm names are listed in Section
         Figure 1.

      compression_algorithms
         Lists the acceptable compression algorithms in order of
         preference.  The chosen compression algorithm MUST be the first
         algorithm on the client's list that is also on the server's
         list.  If there is no such algorithm, both sides MUST
         disconnect.

         Note that "none" must be explicitly listed if it is to be
         acceptable.  The compression algorithm names are listed in
         Section Section 4.2.

      languages
         This is a comma-separated list of language tags in order of
         preference [RFC1766].  Both parties MAY ignore this list.  If
         there are no language preferences, this list SHOULD be empty.

      first_kex_packet_follows
         Indicates whether a guessed key exchange packet follows.  If a
         guessed packet will be sent, this MUST be TRUE.  If no guessed
         packet will be sent, this MUST be FALSE.



Ylonen, et. al.          Expires March 21, 2003                [Page 15]


         After receiving the SSH_MSG_KEXINIT packet from the other side,
         each party will know whether their guess was right.  If the
         other party's guess was wrong, and this field was TRUE, the
         next packet MUST be silently ignored, and both sides MUST then
         act as determined by the negotiated key exchange method.  If
         the guess was right, key exchange MUST continue using the
         guessed packet.

   After the KEXINIT packet exchange, the key exchange algorithm is run.
   It may involve several packet exchanges, as specified by the key
   exchange method.

5.2 Output from Key Exchange

   The key exchange produces two values: a shared secret K, and an
   exchange hash H.  Encryption and authentication keys are derived from
   these.  The exchange hash H from the first key exchange is
   additionally used as the session identifier, which is a unique
   identifier for this connection.  It is used by authentication methods
   as a part of the data that is signed as a proof of possession of a
   private key.  Once computed, the session identifier is not changed,
   even if keys are later re-exchanged.


   Each key exchange method specifies a hash function that is used in
   the key exchange.  The same hash algorithm MUST be used in key
   derivation.  Here, we'll call it HASH.


   Encryption keys MUST be computed as HASH of a known value and K as
   follows:
   o  Initial IV client to server: HASH(K || H || "A" || session_id)
      (Here K is encoded as mpint and "A" as byte and session_id as raw
      data."A" means the single character A, ASCII 65).
   o  Initial IV server to client: HASH(K || H || "B" || session_id)
   o  Encryption key client to server: HASH(K || H || "C" || session_id)
   o  Encryption key server to client: HASH(K || H || "D" || session_id)
   o  Integrity key client to server: HASH(K || H || "E" || session_id)
   o  Integrity key server to client: HASH(K || H || "F" || session_id)

   Key data MUST be taken from the beginning of the hash output.  128
   bits (16 bytes) SHOULD be used for algorithms with variable-length
   keys.  For other algorithms, as many bytes as are needed are taken
   from the beginning of the hash value.  If the key length in longer
   than the output of the HASH, the key is extended by computing HASH of
   the concatenation of K and H and the entire key so far, and appending
   the resulting bytes (as many as HASH generates) to the key.  This
   process is repeated until enough key material is available; the key
   is taken from the beginning of this value.  In other words:




Ylonen, et. al.          Expires March 21, 2003                [Page 16]

Internet-Draft        SSH Transport Layer Protocol        September 2002


     K1 = HASH(K || H || X || session_id)   (X is e.g. "A")
     K2 = HASH(K || H || K1)
     K3 = HASH(K || H || K1 || K2)
     ...
     key = K1 || K2 || K3 || ...

   This process will lose entropy if the amount of entropy in K is
   larger than the internal state size of HASH.

5.3 Taking Keys Into Use

   Key exchange ends by each side sending an SSH_MSG_NEWKEYS message.
   This message is sent with the old keys and algorithms.  All messages
   sent after this message MUST use the new keys and algorithms.


   When this message is received, the new keys and algorithms MUST be
   taken into use for receiving.


   This message is the only valid message after key exchange, in
   addition to SSH_MSG_DEBUG, SSH_MSG_DISCONNECT and SSH_MSG_IGNORE
   messages.  The purpose of this message is to ensure that a party is
   able to respond with a disconnect message that the other party can
   understand if something goes wrong with the key exchange.
   Implementations MUST NOT accept any other messages after key exchange
   before receiving SSH_MSG_NEWKEYS.

     byte      SSH_MSG_NEWKEYS

