#include "ssh.h"

static int
nullmac(ConnHalf *h, Msg *m, uchar *p)
{
	USED(h);
	USED(m);
	USED(p);
	
	return 0;
}

static int
nullcrypt(ConnHalf *h, Msg *m)
{
	USED(h);
	USED(m);
	return 0;
}

static Msg*
nullcompress(ConnHalf *h, Msg *m)
{
	USED(h);

	return m;
}

Conn*
mkconn(int rfd, int wfd)
{
	Conn *z;
	
	z = emalloc(sizeof *z);
	
	z->in.fd = rfd;
	z->in.mac = nullmac;
	z->in.crypt = nullcrypt;
	z->in.compress = nullcompress;
	
	z->out.fd = wfd;
	z->out.mac = nullmac;
	z->out.crypt = nullcrypt;
	z->out.compress = nullcompress;
	return z;
}

