/*
 * 9P service multiplexor
 */
#include "a.h"

Qid rootqid;
Fs *rootfs;
char *user;

Srv fs;
void initfs(void);

void
usage(void)
{
	fprint(2, "usage: 9pmux service [config]\n");
	threadexitsall("usage");
}

void
threadmain(int argc, char **argv)
{
	ARGBEGIN{
	default:
		usage();
	}ARGEND
	
	user = getuser();
	
	if(argc != 1)
		usage();

	chatty9p = 1;

	rootfs = mkrootfs(&rootqid);
	rootcreate("dev", DMDIR|0555);
	rootcreate("fs", DMDIR|0555);
	rootcreate("mnt", DMDIR|0555);
	rootcreate("mnt/acme", DMDIR|0555);
	rootcreate("mnt/factotum", DMDIR|0555);
	rootcreate("mnt/plumb", DMDIR|0555);
	rootcreate("net", DMDIR|0555);

	initfs();
	threadpostmountsrv(&fs, argv[0], nil, 0);
}


void
muxattach(Req *r)
{
	r->fid->qid = rootqid;
	r->ofcall.qid = rootqid;
	respond(r, nil);
}

void
muxauth(Req *r)
{
	respond(r, "authentication not required");
}

Fs*
fidfs(Fid *fid)
{
	return rootfs;
}

void
muxmsg(Req *r)
{
	Fs *fs;

	fs = fidfs(r->fid);
	sendp(fs->reqchan, r);
}

void
initfs(void)
{
//	fs.destroyfid = destroyfid;
//	fs.destroyreq = destroyreq;
//	fs.start = fsstart;
//	fs.end = fsend;
	
	fs.attach = muxattach;
	fs.auth = muxauth;
	fs.open = muxmsg;
	fs.create = muxmsg;
	fs.read = muxmsg;
	fs.write = muxmsg;
	fs.remove = muxmsg;
	fs.flush = muxmsg;
	fs.stat = muxmsg;
	fs.wstat = muxmsg;
	fs.walk = muxmsg;
}

void
wrespond(Req *r, char *err)
{
	respond(r, err);
}
