#include "a.h"

void mntreqthread0(void *v);

void
mntreqthread(void *v)
{
	CFid *fid;
	Fs *fs;
	
	fs = v;
	while((r = recvp(fs->reqchan)) != nil){
		r->aux = fs;
		threadcreate(mntreqthread0, r, STACK);
	}
}

void
mntreqthread0(void *v)
{
	CFid *cfid;
	Fs *fs;
	Req *r;
	uint tag;
	
	r = v;
	fs = r->aux;
	r->aux = &tag;

	if(r->fid){
		cfid = r->fid->aux;
		if(cfid == nil)
			r->fid->aux = cfid = fsclone(fs->aux);
	}
	switch(r->ifcall.type){
	default:
		respond(r, "unknown type");
		break;

	case Tflush:
		while(r->oldreq->aux == fs)
			yield();
		fscancel(fsfromfid(cfid), *(uint*)r->oldreq->aux);
		respond(r, nil);
		break;
		
	case Topen:
		if(fsopenfid(cfid, r->ifcall.omode, &r->ofcall.qid) < 0){
			responderr(r);
			break;
		}
		r->newfid->aux = cfid;
		respond(r, nil);
		break;
		
	case Tread:
		if((n = fspread(cfid, cfid->ofcall.data, cfid->ifcall.count, cfid->ifcall.offset)) < 0){
			responderr(r);
			break;
		}
		r->ofcall.count = n;
		respond(r, nil);
		break;

	case Twrite:
		if((n = fspwrite(cfid, cfid->ifcall.data, cfid->ifcall.count, cfid->ifcall.offset)) < 0){
			responderr(r);
			break;
		}
		r->ofcall.count = n;
		respond(r, nil);
		break;
	
	case Twalk:
		if((n = fswalk(cfid, &nfid, r->ifcall.wname, r->ifcall.nwname, r->ofcall.wqid)) < 0){
			responderr(r);
			break;
		}
		r->ofcall.nwqid = n;
		respond(r, nil);
		break;
	
	case Tcreate:
		if(fscreatefid(cfid, r->ifcall.name, r->ifcall.omode, r->ifcall.perm) < 0){
			responderr(r);
			break;
		}
		respond(r, nil);
		break;
	
	case Tremove:
		if(fsremovefid(cfid) < 0){
			responderr(r);
			break;
		}
		respond(r, nil);
		break;
	
	case Tstat:
		if((d = fsstat(cfid)) == nil){
			responderr(r);
			break;
		}
		r->d = *d;
		r->d.name = estrdup(r->d.name);
		r->d.uid = estrdup(r->d.uid);
		r->d.gid = estrdup(r->d.gid);
		r->d.muid = estrdup(r->d.muid);
		free(d);
		respond(r, nil);
		break;

	case Twstat:
		if(fswstatfid(cfid, &r->d) < 0){
			responderr(r);
			break;
		}
		respond(r, nil);
		break;
	}
}
	
Fs*
mntfs(CFid *fid, Qid *qid)
{
	Fs *fs;
	
	fs = emalloc(sizeof *fs);
	fs->name = "mnt";
	fs->reqchan = chancreate(sizeof(void*), 4);
	fs->aux = fid;
	threadcreate(mntreqthread, fs, STACK);
	*qid = fid->qid;
	return fs;
}

