#include <u.h>
#include <libc.h>

int
pushssl(int fd, char *alg, char *secin, char *secout, int *cfd)
{
	int xfd, p[2], q[2], pid;
	char buf[2];

	if(pipe(p) < 0)
		return -1;
	if(pipe(q) < 0){
		close(p[0]);
		close(p[1]);
		return -1;
	}
	
	pid = fork();
	if(pid < 0){
		close(p[0]);
		close(p[1]);
		close(q[0]);
		close(q[1]);
		return -1;
	}
	
	if(pid == 0){
		close(p[1]);
		close(q[1]);
		/*
		 * Set up 0, 1, 2 if they're not open already.
		 */
		while((xfd = open("/dev/null", ORDWR)) >= 0 && xfd < 3)
			;
		if(xfd >= 0)
			close(xfd);
		/*
		 * Move the fds we're going to use to > 6.
		 */
		while(0 <= fd && fd <= 6)
			fd = dup(fd, -1);
		while(0 <= p[0] && p[0] <= 6)
			p[0] = dup(p[0], -1);
		while(0 <= q[0] && q[0] <= 6)
			q[0] = dup(q[0], -1);
		/*
		 * Now set up 0, 3-6 as we want them.
		 */
		dup(fd, 3);
		dup(fd, 4);
		dup(p[0], 5);
		dup(p[0], 6);
		dup(q[0], 0);
		close(p[0]);
		close(q[0]);
		close(fd);
		
		execl("sslpipe", "sslpipe", nil);
		fprint(2, "exec sslpipe: %r");
		_exits("oops");
	}
	
	close(p[0]);
	close(q[0]);
	/*
	 * Configure the pipe.
	 */
	fprint(q[1], "%s %s '%s'\n", secin, secout, alg);
	if(readn(q[1], buf, 2) != 2 || buf[0]!='O' || buf[1]!='K'){
		werrstr("sslpipe protocol botch");
		close(q[1]);
		close(p[1]);
		return -1;
	}
	close(q[1]);
	
	/*
	 * Replace fd with the cleartext pipe.
	 */
	close(fd);
	dup(p[1], fd);
	close(p[1]);
	return fd;
}
