#include <u.h>
#include <libc.h>
#include <bio.h>
#include <auth.h>
#include <fcall.h>
#include <libsec.h>
#include <thread.h>

void
writestr(int fd, char *str)
{
	int l, n;

	l = strlen(str);
	n = write(fd, str, l+1);
	if(n < 0)
		sysfatal("writing network: %r");
}

int
readstr(int fd, char *str, int len)
{
	int n;

	while(len) {
		n = read(fd, str, 1);
		if(n < 0) 
			return -1;
		if(*str == '\0')
			return 0;
		str++;
		len--;
	}
	return -1;
}

static void
mksecret(char *t, uchar *f)
{
	sprint(t, "%2.2ux%2.2ux%2.2ux%2.2ux%2.2ux%2.2ux%2.2ux%2.2ux%2.2ux%2.2ux",
		f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8], f[9]);
}


int
p9auth(int fd)
{
	uchar key[16];
	uchar digest[SHA1dlen];
	char fromclientsecret[21];
	char fromserversecret[21];
	int i;
	AuthInfo *ai;

	ai = auth_proxy(fd, auth_getkey, "proto=%q role=client %s", "p9any", "");
	if(ai == nil){
		fprint(2, "auth_proxy: %r\n");
		return -1;
	}
	memmove(key+4, ai->secret, ai->nsecret);

	/* exchange random numbers */
	srand(truerand());
	for(i = 0; i < 4; i++)
		key[i] = rand();
	if(write(fd, key, 4) != 4)
		return -1;
	if(readn(fd, key+12, 4) != 4)
		return -1;

	/* scramble into two secrets */
	sha1(key, sizeof(key), digest, nil);
	mksecret(fromclientsecret, digest);
	mksecret(fromserversecret, digest+10);

	/* set up encryption */
	i = pushssl(fd, "rc4_256 sha1", fromclientsecret, fromserversecret, nil);
	if(i < 0)
		werrstr("can't establish ssl connection: %r");
	return i;
}

int fd, fd2;
void thread1(void*);

void
threadmain(int argc, char **argv)
{
	extern int chatty9pclient;
	int n;
	char err[100], buf[100];
	
	chatty9pclient = 1;
	fd = dial("tcp!204.178.31.2!ncpu", 0, 0, 0);
	if(fd < 0)
		sysfatal("dial: %r");
	
	writestr(fd, "p9 rc4_256 sha1");
	n = readstr(fd, err, sizeof err);
	if(n < 0)
		sysfatal("readstr: %r");
	if(*err)
		sysfatal("error: %r");
	fd = p9auth(fd);
	if(fd < 0)
		sysfatal("p9auth: %r");
	fprint(2, "START\n");
fprint(2, "WRITE1\n");
	writestr(fd, "! echo hello from cpu");
fprint(2, "WRITE2\n");
	writestr(fd, "/usr/rsc");
fprint(2, "READ\n");
	if(readstr(fd, buf, sizeof buf) < 0)
		sysfatal("readstr2: %r");
	if(buf[0]!='F' || buf[1]!='S')
		sysfatal("remote cpu: %s", buf);
fprint(2, "READ\n");
	if(readstr(fd, buf, sizeof buf) < 0)
		sysfatal("readstr3: %r");
fprint(2, "WRITE3\n");
	write(fd, "OK", 2);
	
	print("all is well\n");
	
	if((fd2 = dial(smprint("unix!%s/mux", getns()), nil, nil, nil)) < 0)
		sysfatal("dial mux: %r");
	proccreate(thread1, (void*)1, 128*1024);
	thread1(0);
}

void
thread1(void *v)
{
	int r, w, n;
	char buf[65536];
	
	if(v){
		r = fd;
		w = fd2;
	}else{
		r = fd2;
		w = fd;
	}
	
	while((n = read(r, buf, sizeof buf)) > 0){
		fprint(2, "r%d:%d...", (int)v, n);
		if(write(w, buf, n) != n)
			sysfatal("write error");
	}
	if(n < 0)
		sysfatal("read error");
	threadexitsall(nil);
}
