;; a trivial example using channels with the lisp Tk implementation.
;; requires ltk (see http://www.peter-herth.de/ltk/ltkdoc/)

(require :csp)
(require :ltk)
(use-package :ltk)
(use-package :csp)

;; unfortunately there's no way of knowing in advance which variables are important.
(add-inherit '(*ltk-version* *wish* *wish-connections* *debug-tk* *trace-tk* *wish-pathname* *wish-args* *init-wish-hook* *generate-accessors* *initargs* *class-args* *cursors* *tk* *mb-icons* *ltk-default-debugger* *debug-settings-table* *exit-mainloop* *break-mainloop* *do-rotate* *demo-line* *demo-canvas*))

(defvar *tkc* (chan))

(defun string+ (&rest s)
  (apply #'concatenate 'string s))

(defmacro tkcmd (&rest forms)
  `(let ((reply (chan)))
    (! *tkc* (list #'(lambda () ,@forms) reply))
    (? reply)))

(defun button (c msg)
  (tkcmd (pack (make-instance 'button 
			      :text msg
			      :command #'(lambda () (! c msg))))))

;; main loop (monitor, although it might not need to be)
(spawn 
 (with-ltk ()
   (spawn 
    (loop
     (alt ((? *tkc* (f reply))
	   (! reply (funcall f))))))))

(let ((c (chan)))
  (spawn
   (loop 
    for i = 0 then (1+ i) do
    (let ((title (? c)))
      (button c (format nil "~a.~d" title i)))))
  (button c "hello"))
