#include <u.h>
#include <libc.h>
#include <fcall.h>
#include "dat.h"
#include <auth.h>
#include "fns.h"

void*
emalloc(ulong sz)
{
	void *v;
	if((v = malloc(sz)) == nil){
		postnote(PNGROUP, getpid(), "inconceivable");
		sysfatal("out of memory");
	}
	memset(v, 0, sz);
	setmalloctag(v, getcallerpc(&sz));
	return v;
}

char*
estrdup(char *s)
{
	char *ns;

	ns = emalloc(strlen(s)+1);
	strcpy(ns, s);
	setmalloctag(ns, getcallerpc(&s));
	return ns;
}

void*
erealloc(void *v, ulong sz)
{
	if((v = realloc(v, sz)) == nil){
		postnote(PNGROUP, getpid(), "inconceivable");
		sysfatal("out of memory");
	}
	setrealloctag(v, getcallerpc(&v));
	return v;
}

void
chat(char *fmt, ...)
{
	char buf[1024];
	va_list arg;

	if(!chatty)
		return;

	va_start(arg, fmt);
	vseprint(buf, buf+sizeof(buf), fmt, arg);
	va_end(arg);
	fprint(2, "%s", buf);
}

