#include <u.h>
#include <libc.h>
#include <fcall.h>
#include "dat.h"
#include <auth.h>
#include "fns.h"

Idmap reqmap;
ulong taggen = 0x10000;

Req*
allocreq(ulong tag, Req *reqspc)
{
	Req *r;
	int sz;

	sz = sizeof(Req);

	r = (Req*)allocid(&reqmap, tag, sz, (void *)reqspc);
	if(r){
		r->fid=nil;
		r->newfid=nil;
		r->internal=0;
		r->isattach=0;
		r->isclunk=0;
		r->flushing=0;
		r->gen=0;
	}
	return r;
}

Req*
lookuplreq(ulong tag)
{
	return (Req*)lookuplocal(&reqmap, tag);
}

Req*
lookuprreq(ushort tag)
{
	Req *r;

	r = (Req*)lookupremote(&reqmap, tag);
	return r;
}

Fcall last[256];
int nlast;

void
dumplast(void)
{
	int i, pid;

	i = nlast - 256;
	if(i < 0)
		i = 0;

	pid = getpid();
	for(; i<nlast; i++)
		syslog(0, logfile, "[%d] log %d %F", pid, i, &last[i&(nelem(last)-1)]);
}

/*
 * Copy buffer for f from old to new and adjust pointers in f.
 */
void
movefcall(uchar *dst, uchar *src, Fcall *f)
{
	int i;
	long delta;
	
	memmove(dst, src, GBIT32(src));
	delta = dst - src;

	switch(f->type){
	case Tversion:
		f->version += delta;
		break;
	case Tattach:
	case Tauth:
		f->uname += delta;
		f->aname += delta;
		break;
	case Tcreate:
		f->name += delta;
		break;
	case Twalk:
		for(i=0; i<f->nwname; i++)
			if(f->wname[i])
				f->wname[i] += delta;
		break;
	case Rread:
	case Twrite:
		f->data += delta;
		break;
	case Rstat:
	case Twstat:
		f->stat += delta;
		break;
	}
}

/*
 * Queue/send a request.  Still has pointers into caller buffer
 *  into r->buf.
 */
void
queuereq(Req *r)
{
	uchar *buf;
	long n;
	Fid *fid;

	fid = r->fid;

	if(r->fcall.type == Tread && fid && fid->type&QTDIR)		/* readdir special case */
		if(fid->dirscount < fid->dirccount && r->fcall.offset != 0){
			chat("	adjusting readdir, dirscount %ud, dirccount %ud", fid->dirscount, fid->dirccount);
			r->fcall.offset -= fid->dirccount - fid->dirscount;
		}

	buf = emalloc(MAXPKT);
	if(!buf)
		sysfatal("not enough memory");
	
	r->fcall.tag = r->tag.remote;
	if(fid)
		r->fcall.fid = fid->fid.remote;
	if(r->newfid)
		r->fcall.newfid = r->newfid->fid.remote;
	r->gen = gen;

	if(r->internal || fidready(r->fid)){
		/* RSC package this up */
		n = convS2M(&r->fcall, buf, MAXPKT);
		if(n <= BIT32SZ)
			sysfatal("convS2M: %r");
		chat("net <- %F\n", &r->fcall);
		last[nlast++&(nelem(last)-1)] = r->fcall;
		write(netfd, buf, n);
	}
	free(buf);
}

void
freereq(Req *r)
{
	freeid(&reqmap, &r->tag); 
}

int
forallreqs(void (*fn)(Req*, void*), void *arg)
{
	Id *r, *rlink;
	int i, n;

	n = 0;

	for(i=0; i<nelem(reqmap.lhash); i++){
		for(r=reqmap.lhash[i]; r; r=rlink){
			rlink = r->rlink;
			if(fn)
				fn((Req*)r, arg);
			n++;
		}
	}
	return n;
}

static void
dump(Req *r, void *p)
{
	USED(p);

	chat("%F\n", &r->fcall);
}

void
dumpreqs(void)
{
	int n;
	
	chat("outstanding requests:\n");
	n = forallreqs(dump, nil);
	chat("%d total\n", n);
}
